package cn.gtmap.bdcdj.core.encrypt;


import cn.gtmap.bdcdj.core.encrypt.executor.CryptType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

public class CryptProperties {
    //加解密总开关
    private boolean cryptEnable;
    //加解密方式
    private CryptType cryptType;

    private String separator;//设置加解密分隔字符，加密当遇到此分隔字符时，字符前后分别进行加密，如果不配置，会有默认的分隔字符。但是由于使用用户自定义的key之后，加密得到的字符串会包含分隔字符，所以当自定义key时，需要指定分隔符
    private boolean isUserSm4KeyEnable;//是否使用用户自定义的key进行sm4加解密，如果配置为true，需还要配置以下配置：sm4Salt、sm4key、encoding
    private String sm4Salt;//isUserSm4KeyEnable为true时，sm4加密时使用的salt，当isUserSm4KeyEnable不为true时，取常量而非此配置
    private String sm4key;//isUserSm4KeyEnable为true时，加密使用的key，需要固定长度的字符串，否则报错
    private String encoding;//isUserSm4KeyEnable为true时，使用的编码

    //全局加解密字段
    private List<String> globalEnableFields ;
    //map中全局加解密字段的例外（在例外中不加解密）
    private List<Map> globalDisableEntityFields;
    //entity中全局加解密字段的例外（在例外中不加解密）
    private List<Map> globalDisableMapFields;
    //sql加解密字段
    private List<Map> sqlFields;
    //sql仅加密字段
    private List<Map> sqlEncryptFields;
    //sql仅解密字段
    private List<Map> sqlDecryptFields;
    //实体加解密字段
    private List<Map> entityFields;
    //sql参数为单独的string,对参数加密（等价于注解）
    private List<String> sqlSingleEncryptFields;
    //sql返回值为单独的string,对返回值加密（等价于注解）
    private List<String> sqlSingleDecryptFields;
    public CryptProperties(boolean cryptEnable) {
        this.cryptEnable = cryptEnable;
    }
    public CryptProperties(boolean cryptEnable,CryptType cryptType) {
        this.cryptEnable = cryptEnable;
        this.cryptType = cryptType;
    }

    public List<String> getSqlSingleEncryptFields() {
        return sqlSingleEncryptFields;
    }

    public void setSqlSingleEncryptFields(List<String> sqlSingleEncryptFields) {
        this.sqlSingleEncryptFields = sqlSingleEncryptFields;
    }

    public List<String> getSqlSingleDecryptFields() {
        return sqlSingleDecryptFields;
    }

    public void setSqlSingleDecryptFields(List<String> sqlSingleDecryptFields) {
        this.sqlSingleDecryptFields = sqlSingleDecryptFields;
    }

    public boolean isUserSm4KeyEnable() {
        return isUserSm4KeyEnable;
    }

    public void setUserSm4KeyEnable(boolean userSm4KeyEnable) {
        isUserSm4KeyEnable = userSm4KeyEnable;
    }

    public String getEncoding() {
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getSm4key() {
        return sm4key;
    }

    public void setSm4key(String sm4key) {
        this.sm4key = sm4key;
    }


    public String getSm4Salt() {
        return sm4Salt;
    }

    public void setSm4Salt(String sm4Salt) {
        this.sm4Salt = sm4Salt;
    }

    public String getSeparator() {
        return separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public CryptType getCryptType() {
        return cryptType;
    }

    public void setCryptType(CryptType cryptType) {
        this.cryptType = cryptType;
    }

    public boolean isCryptEnable() {
        return cryptEnable;
    }

    public void setCryptEnable(boolean cryptEnable) {
        this.cryptEnable = cryptEnable;
    }

    public List<String> getGlobalEnableFields() {
        return globalEnableFields;
    }

    public void setGlobalEnableFields(List<String> globalEnableFields) {
        this.globalEnableFields = globalEnableFields;
    }

    public List<Map> getGlobalDisableEntityFields() {
        return globalDisableEntityFields;
    }

    public void setGlobalDisableEntityFields(List<Map> globalDisableEntityFields) {
        this.globalDisableEntityFields = globalDisableEntityFields;
    }

    public List<Map> getGlobalDisableMapFields() {
        return globalDisableMapFields;
    }

    public void setGlobalDisableMapFields(List<Map> globalDisableMapFields) {
        this.globalDisableMapFields = globalDisableMapFields;
    }

    public List<Map> getSqlFields() {
        return sqlFields;
    }

    public void setSqlFields(List<Map> sqlFields) {
        this.sqlFields = sqlFields;
    }

    public List<Map> getSqlEncryptFields() {
        return sqlEncryptFields;
    }

    public void setSqlEncryptFields(List<Map> sqlEncryptFields) {
        this.sqlEncryptFields = sqlEncryptFields;
    }

    public List<Map> getSqlDecryptFields() {
        return sqlDecryptFields;
    }

    public void setSqlDecryptFields(List<Map> sqlDecryptFields) {
        this.sqlDecryptFields = sqlDecryptFields;
    }

    public List<Map> getEntityFields() {
        return entityFields;
    }

    public void setEntityFields(List<Map> entityFields) {
        this.entityFields = entityFields;
    }

    public boolean isEncryptDecryptEntityField(String entityName, String fieldName) {
        if(StringUtils.isAnyBlank(entityName,fieldName)){
            return false;
        }
        if(isGlobalFields(null, entityName, fieldName)){
            return true;
        }else{
            List<Map> entityFields = getEntityFields();
            if(getEntityContainsField(entityFields,entityName,fieldName)){
                return true;
            }else{
                return false;
            }
        }
    }

    public boolean isEncryptMapField(String mapid, String fieldName) {
        if(StringUtils.isAnyBlank(mapid,fieldName)){
            return false;
        }
        if(isGlobalFields(mapid,null, fieldName)){
            return true;
        }else{
            List<Map> sqlFields = getSqlFields();
            List<Map> sqlEncryptFields = getSqlEncryptFields();
            if(getMapContainsField(sqlFields,mapid,fieldName) || getMapContainsField(sqlEncryptFields,mapid,fieldName)){
                return true;
            }else{
                return false;
            }
        }
    }

    public boolean isDecryptMapField(String mapid, String fieldName) {
        if(StringUtils.isAnyBlank(mapid,fieldName)){
            return false;
        }
        if(isGlobalFields(mapid,null, fieldName)){
            return true;
        }else{
            List<Map> sqlFields = getSqlFields();
            List<Map> sqlDecryptFields = getSqlDecryptFields();
            if(getMapContainsField(sqlFields,mapid,fieldName) || getMapContainsField(sqlDecryptFields,mapid,fieldName)){
                return true;
            }else{
                return false;
            }
        }
    }
    /**
     * 判断是否是全局加解密字段
     * @param fieldName
     * @return
     */
    private boolean isGlobalFields(String mapid,String entityName,String fieldName){
        List<String> globalEnableFields = getGlobalEnableFields();
        List<Map> globalDisableMapFields = getGlobalDisableMapFields();
        List<Map> globalDisableEntityFields = getGlobalDisableEntityFields();
//        if(CollectionUtils.isNotEmpty(globalEnableFields) && globalEnableFields.contains(fieldName)){
        if(CollectionUtils.isNotEmpty(globalEnableFields) && containsIgnoreCase(globalEnableFields,fieldName)){
            //是全局变量，看是map还是entity
            if(StringUtils.isNotBlank(mapid) && CollectionUtils.isNotEmpty(globalDisableMapFields)){
                for (Map globalDisableMapField : globalDisableMapFields) {
                    if(mapid.endsWith(MapUtils.getString(globalDisableMapField,"mapid"))
                            && StringUtils.equalsIgnoreCase(fieldName,MapUtils.getString(globalDisableMapField,"field"))){
                        return false;//反向判断，暂时不抽取方法
                    }
                }
                return true;
            }else if(StringUtils.isNotBlank(entityName) && CollectionUtils.isNotEmpty(globalDisableEntityFields)){
                for (Map globalDisableEntityField : globalDisableEntityFields) {
                    if(entityName.endsWith(MapUtils.getString(globalDisableEntityField,"entity"))
                            && StringUtils.equalsIgnoreCase(fieldName,MapUtils.getString(globalDisableEntityField,"field"))){
                        return false;//反向判断，暂时不抽取方法
                    }
                }
                return true;
            }else{
                return true;
            }
        }else{//不是全局变量，返回false
            return false;
        }
    }
    private boolean containsIgnoreCase(List<String> list,String s){
        if(CollectionUtils.isNotEmpty(list)){
            for (String s1 : list) {
                if(StringUtils.equalsIgnoreCase(s1,s)){
                    return true;
                }
            }
            return false;
        }else{
            return false;
        }
    }
    private boolean getEntityContainsField(List<Map> list,String entityName,String fieldName){
        if(CollectionUtils.isNotEmpty(list)){
            for (Map map : list) {
                if(entityName.endsWith(MapUtils.getString(map,"entity"))
                        && StringUtils.equalsIgnoreCase(fieldName,MapUtils.getString(map,"field"))){
                    return true;
                }
            }
            return false;
        }else{
            return false;
        }
    }
    private boolean getMapContainsField(List<Map> list,String mapid,String fieldName){
        if(CollectionUtils.isNotEmpty(list)){
            for (Map map : list) {
                if(mapid.endsWith(MapUtils.getString(map,"mapid"))
                        && StringUtils.equalsIgnoreCase(fieldName,MapUtils.getString(map,"field"))){
                    return true;
                }
            }
            return false;
        }else{
            return false;
        }
    }
}
