package cn.gtmap.bdcdj.core.encrypt;

import cn.gtmap.bdcdj.core.encrypt.annotation.Encrypt;
import cn.gtmap.bdcdj.core.encrypt.annotation.Encrypts;
import cn.gtmap.bdcdj.core.encrypt.config.BaseConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.signers.ECNRSigner;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultText;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DbEncryptXmlConfig {
    private Resource configUrl;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbEncryptXmlConfig.class);
    public Resource getConfigUrl() {
        return configUrl;
    }
    @Autowired
    List<BaseConfig> baseConfig;
    //全局加解密字段
    private List<String> globalEnableFields ;
    //map中全局加解密字段的例外（在例外中不加解密）
    private List<Map> globalDisableEntityFields;
    //entity中全局加解密字段的例外（在例外中不加解密）
    private List<Map> globalDisableMapFields;
    //sql加解密字段
    private List<Map> sqlFields;
    //sql仅加密字段
    private List<Map> sqlEncryptFields;
    //sql仅解密字段
    private List<Map> sqlDecryptFields;
    //实体加解密字段
    private List<Map> entityFields;
    //sql参数为单独的string,对参数加密（等价于注解）
    private List<String> sqlSingleEncryptFields;
    //sql返回值为单独的string,对返回值加密（等价于注解）
    private List<String> sqlSingleDecryptFields;
    //接口加解密列表
    private List<String> interfaceEncryptList;
    private String interfaceSm2DecodeKey;//接口加解密时，sm2解密的私钥
    private String interfaceSm2EncodeKey;//接口加解密时，sm2加密的公钥
    private List<String> baseConfigOptions;

    //注解加解密相关配置,配置不出现于CryptProperties对象中，在此类中处理后存在其他属性中
    //注解加解密总开关
    private boolean annoEnable;
    //生效的注解分组名称列表
    private List<String> annoGroupNames;
    //实体类注解扫描包
    private String annoEntityPackage;
    //sql方法注解扫描包
    private String annoSqlPackage;


    public void setBaseConfig(List<BaseConfig> baseConfig) {
        this.baseConfig = baseConfig;
    }

    public void setGlobalEnableFields(List<String> globalEnableFields) {
        this.globalEnableFields = globalEnableFields;
    }

    public void setGlobalDisableEntityFields(List<Map> globalDisableEntityFields) {
        this.globalDisableEntityFields = globalDisableEntityFields;
    }

    public void setGlobalDisableMapFields(List<Map> globalDisableMapFields) {
        this.globalDisableMapFields = globalDisableMapFields;
    }

    public void setSqlFields(List<Map> sqlFields) {
        this.sqlFields = sqlFields;
    }

    public void setSqlEncryptFields(List<Map> sqlEncryptFields) {
        this.sqlEncryptFields = sqlEncryptFields;
    }

    public void setSqlDecryptFields(List<Map> sqlDecryptFields) {
        this.sqlDecryptFields = sqlDecryptFields;
    }

    public void setEntityFields(List<Map> entityFields) {
        this.entityFields = entityFields;
    }

    public void setSqlSingleEncryptFields(List<String> sqlSingleEncryptFields) {
        this.sqlSingleEncryptFields = sqlSingleEncryptFields;
    }

    public void setSqlSingleDecryptFields(List<String> sqlSingleDecryptFields) {
        this.sqlSingleDecryptFields = sqlSingleDecryptFields;
    }

    public void setInterfaceEncryptList(List<String> interfaceEncryptList) {
        this.interfaceEncryptList = interfaceEncryptList;
    }

    public void setInterfaceSm2DecodeKey(String interfaceSm2DecodeKey) {
        this.interfaceSm2DecodeKey = interfaceSm2DecodeKey;
    }

    public void setInterfaceSm2EncodeKey(String interfaceSm2EncodeKey) {
        this.interfaceSm2EncodeKey = interfaceSm2EncodeKey;
    }

    public void setBaseConfigOptions(List<String> baseConfigOptions) {
        this.baseConfigOptions = baseConfigOptions;
    }

    public List<String> getBaseConfigOptions() {
        if(CollectionUtils.isNotEmpty(this.baseConfigOptions)){
            return this.baseConfigOptions;
        }else{
            this.baseConfigOptions = getArrFields("BaseConfigOptions");
            return this.baseConfigOptions;
        }
    }

    public void cleanConfig(){
        setGlobalEnableFields(null);
        setGlobalDisableEntityFields(null);
        setGlobalDisableMapFields(null);
        setSqlFields(null);
        setSqlEncryptFields(null);
        setSqlDecryptFields(null);
        setEntityFields(null);
        setSqlSingleEncryptFields(null);
        setSqlSingleDecryptFields(null);
        setInterfaceEncryptList(null);
        setInterfaceSm2DecodeKey(null);
        setInterfaceSm2EncodeKey(null);
        setBaseConfigOptions(null);
        setAnnoGroupNames(null);
        setAnnoEntityPackage(null);
        setAnnoSqlPackage(null);
    }
    public String getInterfaceSm2DecodeKey(){
        if(!StringUtils.isBlank(this.interfaceSm2DecodeKey)){
            return this.interfaceSm2DecodeKey;
        }else{
            this.interfaceSm2DecodeKey = getField("InterfaceSm2DecodeKey");
            return this.interfaceSm2DecodeKey;
        }
    }
    public String getInterfaceSm2EncodeKey(){
        if(!StringUtils.isBlank(this.interfaceSm2EncodeKey)){
            return this.interfaceSm2EncodeKey;
        }else {
            this.interfaceSm2EncodeKey = getField("InterfaceSm2EncodeKey");
            return this.interfaceSm2EncodeKey;
        }
    }
    public List<String> getInterfaceEncryptList(){
        if(CollectionUtils.isNotEmpty(this.interfaceEncryptList)){
            return this.interfaceEncryptList;
        }else {
            List<String> list = new ArrayList<String>();
            list = getFieldsInOneField("IneterfaceEcnrypt", "patternUrl");
            this.interfaceEncryptList = list;
            return list;
        }
    }
    public List<String> getSqlSingleEncryptFields(){
        if(CollectionUtils.isNotEmpty(this.sqlSingleEncryptFields)){
            return this.sqlSingleEncryptFields;
        }else{
            this.sqlSingleEncryptFields = getArrFields("SqlSingleEncryptFields");
            return this.sqlSingleEncryptFields;
        }
    }
    public List<String> getSqlSingleDecryptFields(){
        if(CollectionUtils.isNotEmpty(this.sqlSingleDecryptFields)){
            return this.sqlSingleDecryptFields;
        }else{
            this.sqlSingleDecryptFields = getArrFields("SqlSingleDecryptFields");
            return this.sqlSingleDecryptFields;
        }
    }

    public void setConfigUrl(Resource configUrl) {
        this.configUrl = configUrl;
    }


    public List<String> getGlobalEnableFields(){
        if(globalEnableFields == null) {
            globalEnableFields = getArrFields("GlobalEnableFields");
        }
        return globalEnableFields;
    }

    public List<Map> getGlobalDisableMapFields()  {
        if(globalDisableMapFields == null){
            List<String> globalDisableEntityFieldList = getArrFields("GlobalDisableMapFields");
            if(CollectionUtils.isNotEmpty(globalDisableEntityFieldList)){
                globalDisableMapFields = new ArrayList<Map>();
                for (String s : globalDisableEntityFieldList) {
                    int i = s.lastIndexOf(".");
                    String mapid = s.substring(0, i);
                    String fieldName = s.substring(i+1);
                    Map entityDisableMap = new HashMap<String,Object>();
                    entityDisableMap.put("mapid",mapid);
                    entityDisableMap.put("field",fieldName);
                    globalDisableMapFields.add(entityDisableMap);
                }
            }
        }
        return globalDisableMapFields;
    }

    public List<Map> getGlobalDisableEntityFields()  {
        if(globalDisableEntityFields == null){
            List<String> globalDisableEntityFieldList = getArrFields("GlobalDisableEntityFields");
            if(CollectionUtils.isNotEmpty(globalDisableEntityFieldList)){
                globalDisableEntityFields = new ArrayList<Map>();
                for (String s : globalDisableEntityFieldList) {
                    int i = s.lastIndexOf(".");
                    String beanName = s.substring(0, i);
                    String fieldName = s.substring(i+1);
                    Map entityDisableEntityMap = new HashMap<String,Object>();
                    entityDisableEntityMap.put("entity",beanName);
                    entityDisableEntityMap.put("field",fieldName);
                    globalDisableEntityFields.add(entityDisableEntityMap);
                }
            }
        }
        return globalDisableEntityFields;
    }

    public List<Map> getSqlFields()  {
        if(sqlFields == null){
            List<String> getSqlFieldsList = getArrFields("SqlFields");
            if(CollectionUtils.isNotEmpty(getSqlFieldsList)){
                sqlFields = new ArrayList<Map>();
                for (String s : getSqlFieldsList) {
                    int i = s.lastIndexOf(".");
                    String mapid = s.substring(0, i);
                    String fieldName = s.substring(i+1);
                    Map sqlFieldsMap = new HashMap<String,Object>();
                    sqlFieldsMap.put("mapid",mapid);
                    sqlFieldsMap.put("field",fieldName);
                    sqlFields.add(sqlFieldsMap);
                }
            }
        }
        return sqlFields;
    }

    public List<Map> getSqlEncryptFields()  {
        if(sqlEncryptFields == null){
            List<String> getSqlEncryptFieldsList = getArrFields("SqlEncryptFields");
            if(CollectionUtils.isNotEmpty(getSqlEncryptFieldsList)){
                sqlEncryptFields = new ArrayList<Map>();
                for (String s : getSqlEncryptFieldsList) {
                    int i = s.lastIndexOf(".");
                    String mapid = s.substring(0, i);
                    String fieldName = s.substring(i+1);
                    Map sqlEncryptFieldsMap = new HashMap<String,Object>();
                    sqlEncryptFieldsMap.put("mapid",mapid);
                    sqlEncryptFieldsMap.put("field",fieldName);
                    sqlEncryptFields.add(sqlEncryptFieldsMap);
                }
            }
        }
        return sqlEncryptFields;
    }

    public List<Map> getSqlDecryptFields()  {
        if(sqlDecryptFields == null){
            List<String> getSqlDecryptFieldsList = getArrFields("SqlDecryptFields");
            if(CollectionUtils.isNotEmpty(getSqlDecryptFieldsList)){
                sqlDecryptFields = new ArrayList<Map>();
                for (String s : getSqlDecryptFieldsList) {
                    int i = s.lastIndexOf(".");
                    String mapid = s.substring(0, i);
                    String fieldName = s.substring(i+1);
                    Map sqlDecryptFieldsMap = new HashMap<String,Object>();
                    sqlDecryptFieldsMap.put("mapid",mapid);
                    sqlDecryptFieldsMap.put("field",fieldName);
                    sqlDecryptFields.add(sqlDecryptFieldsMap);
                }
            }
        }
        return sqlDecryptFields;
    }

    public List<Map> getEntityFields()  {
        if(entityFields == null){
            List<String> getEntityFieldsList = getArrFields("EntityFields");
            if(CollectionUtils.isNotEmpty(getEntityFieldsList)){
                entityFields = new ArrayList<Map>();
                for (String s : getEntityFieldsList) {
                    int i = s.lastIndexOf(".");
                    String mapid = s.substring(0, i);
                    String fieldName = s.substring(i+1);
                    Map entityFieldsMap = new HashMap<String,Object>();
                    entityFieldsMap.put("entity",mapid);
                    entityFieldsMap.put("field",fieldName);
                    entityFields.add(entityFieldsMap);
                }
            }
        }
        return entityFields;
    }





    public List<String> getArrFields(String fieldName){
        SAXReader sr = new SAXReader();
        Document document = null;
        List<String> result = new ArrayList<String>();
        try {
            document = sr.read(configUrl.getFile());
        } catch (Exception e) {
            LOGGER.error(null, e);
        }
        if(document != null){
            Element root = document.getRootElement();
            if(root != null) {
                Element globalEnableFields = root.element(fieldName);
                if(globalEnableFields != null){
                    String value = "";
                    if (CollectionUtils.isNotEmpty(((DefaultElement) globalEnableFields).content())) {
                        value = ((DefaultText) ((DefaultElement) globalEnableFields).content().get(0)).getText().trim();
                    }
//                    String value = globalEnableFields.elementTextTrim("value");
                    if(StringUtils.isNotBlank(value)){
                        String[] split = value.split(",");
                        if(split != null && split.length > 0){
                            for (String s : split) {
                                result.add(s);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }
    public List<String> getFieldsInOneField(String fieldName,String secondFieldName){
        SAXReader sr = new SAXReader();
        Document document = null;
        List<String> result = new ArrayList<String>();
        try {
            document = sr.read(configUrl.getFile());
        } catch (Exception e) {
            LOGGER.error(null, e);
        }
        if(document != null){
            Element root = document.getRootElement();
            if(root != null) {
                Element globalEnableFields = root.element(fieldName);
                if(globalEnableFields != null){
                    if(globalEnableFields.elements() != null && CollectionUtils.isNotEmpty(globalEnableFields.elements())){
                        List elements = globalEnableFields.elements();
                        for (Object obj : elements) {
                            Element element = (Element)obj;
                            List content = element.content();
                            if(CollectionUtils.isNotEmpty(content)){
                                DefaultText defaultText = (DefaultText)content.get(0);
                                if(defaultText != null && defaultText.getParent() != null
                                        && defaultText.getParent().getQName() != null
                                        && StringUtils.isNotBlank(defaultText.getParent().getQName().getName())
                                        && StringUtils.equals(secondFieldName,defaultText.getParent().getQName().getName()) ){
                                    String text = defaultText.getText();
                                    if(StringUtils.isNotBlank(text)){
                                        result.add(text);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }
    public String getField(String fieldName){
        SAXReader sr = new SAXReader();
        Document document = null;
        String value = "";
        try {
            document = sr.read(configUrl.getFile());
        } catch (Exception e) {
            LOGGER.error(null, e);
        }
        if(document != null){
            Element root = document.getRootElement();
            if(root != null) {
                Element globalEnableFields = root.element(fieldName);
                if(globalEnableFields != null){
                    if (CollectionUtils.isNotEmpty(((DefaultElement) globalEnableFields).content())) {
                        value = ((DefaultText) ((DefaultElement) globalEnableFields).content().get(0)).getText().trim();
                    }
//                    value = globalEnableFields.elementTextTrim("value");
                }
            }
        }
        return value;
    }
    public boolean getBooleanField(String fieldName){
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(configUrl.getFile());
        } catch (Exception e) {
            LOGGER.error(null, e);
        }
        if(document != null){
            Element root = document.getRootElement();
            if(root != null) {
                Element globalEnableFields = root.element(fieldName);
                if(globalEnableFields != null){
                    String stringVal = "";
                    if (CollectionUtils.isNotEmpty(((DefaultElement) globalEnableFields).content())) {
                        stringVal = ((DefaultText) ((DefaultElement) globalEnableFields).content().get(0)).getText().trim();
                    }
//                    String stringVal = globalEnableFields.elementTextTrim("value");
                    if(StringUtils.isNotBlank(stringVal) && StringUtils.equals("true",stringVal)){
                        return true;
                    }
                }
            }
        }
        return false;
    }
    /**
     * 从java文件中读取预置的加解密字段
     */
    public void addBaseConfigFields() {
        List<String> baseConfigOptions = this.getBaseConfigOptions();
        if(CollectionUtils.isNotEmpty(baseConfig)){
            for (BaseConfig config : baseConfig) {
                String simpleName = config.getClass().getSimpleName().replace("Config", "").toLowerCase();
                //当配置中包含预置加密字段时，才读预置字段
                if(baseConfigOptions.contains(simpleName)){
                    //预置的全局加解密字段（正向配置）
                    if(CollectionUtils.isNotEmpty(config.getGlobalEnableFields())){
                        if(CollectionUtils.isEmpty(globalEnableFields)){
                            globalEnableFields = new ArrayList<String>();
                        }
                        globalEnableFields.addAll(config.getGlobalEnableFields());
                    }
                    //预置的sql加解密字段（正向配置）
                    if(CollectionUtils.isNotEmpty(config.getSqlFields())){
                        if(CollectionUtils.isEmpty(sqlFields)){
                            sqlFields = new ArrayList<Map>();
                        }
                        sqlFields.addAll(config.getSqlFields());
                    }
                    //预置的sql加密字段（正向配置）
                    if(CollectionUtils.isNotEmpty(config.getSqlEncryptFields())){
                        if(CollectionUtils.isEmpty(sqlEncryptFields)){
                            sqlEncryptFields = new ArrayList<Map>();
                        }
                        sqlEncryptFields.addAll(config.getSqlEncryptFields());
                    }
                    //预置的sql解密字段（正向配置）
                    if(CollectionUtils.isNotEmpty(config.getSqlDecryptFields())){
                        if(CollectionUtils.isEmpty(sqlDecryptFields)){
                            sqlDecryptFields = new ArrayList<Map>();
                        }
                        sqlDecryptFields.addAll(config.getSqlDecryptFields());
                    }
                    //预置的实体加解密字段（正向配置）
                    if(CollectionUtils.isNotEmpty(config.getEntityFields())){
                        if(CollectionUtils.isEmpty(entityFields)){
                            entityFields = new ArrayList<Map>();
                        }
                        entityFields.addAll(config.getEntityFields());
                    }
                    //单一string作为参数加密(正向配置)
                    if(CollectionUtils.isNotEmpty(config.getSqlSingleEncryptFields())){
                        if(CollectionUtils.isEmpty(sqlSingleEncryptFields)){
                            sqlSingleEncryptFields = new ArrayList<String>();
                        }
                        sqlSingleEncryptFields.addAll(config.getSqlSingleEncryptFields());
                    }
                    //单一string作为返回值解密（正向配置）
                    if(CollectionUtils.isNotEmpty(config.getSqlSingleDecryptFields())){
                        if(CollectionUtils.isEmpty(sqlSingleDecryptFields)){
                            sqlSingleDecryptFields = new ArrayList<String>();
                        }
                        sqlSingleDecryptFields.addAll(config.getSqlSingleDecryptFields());
                    }
                    //全局加密字段在sql中的反向配置（配置在其中的不进行加解密处理） 反向配置
                    //不需要做特殊处理逻辑，因为在判断是否为加解密字段时，判断顺序为：是否为全局加解密字段-》是否为全局非加解密字段-》是否为加解密字段，所以是否为加解密字段本身优先级高于全局配置，不需要在此处根据已有的是否为加解密字段配置调整是否为全局非加解密字段
                    if(CollectionUtils.isNotEmpty(config.getGlobalDisableMapFields())){
                        if(CollectionUtils.isEmpty(globalDisableMapFields)){
                            globalDisableMapFields = new ArrayList<Map>();
                        }
                        globalDisableMapFields.addAll(config.getGlobalDisableMapFields());
                    }
                    //全局姐姐们字段在entity中的反向配置（配置在其中的不进行加解密处理） 反向配置
                    //不做特殊逻辑处理，原因同上
                    if(CollectionUtils.isNotEmpty(config.getGlobalDisableEntityFields())){
                        if(CollectionUtils.isEmpty(globalDisableEntityFields)){
                            globalDisableEntityFields = new ArrayList<Map>();
                        }
                        globalDisableEntityFields.addAll(config.getGlobalDisableEntityFields());
                    }
                }
            }
        }
    }
    //对注解加解密的处理


    public boolean isAnnoEnable() {
        return getBooleanField("AnnoEnable");
    }

    public void setAnnoEnable(boolean annoEnable) {
         this.annoEnable = annoEnable;
    }

    public List<String> getAnnoGroupNames() {
        if(annoGroupNames == null){
            annoGroupNames = getArrFields("AnnoGroupNames");
        }
        return annoGroupNames;
    }

    public void setAnnoGroupNames(List<String> annoGroupNames) {
        this.annoGroupNames = annoGroupNames;
    }

    public String getAnnoEntityPackage() {
        if(StringUtils.isBlank(annoEntityPackage)){
            annoEntityPackage = getField("AnnoEntityPackage");
        }
        return annoEntityPackage;
    }

    public void setAnnoEntityPackage(String annoEntityPackage) {
        this.annoEntityPackage = annoEntityPackage;
    }

    public String getAnnoSqlPackage() {
        if(StringUtils.isBlank(annoSqlPackage)){
            annoSqlPackage = getField("AnnoSqlPackage");
        }
        return annoSqlPackage;
    }

    public void setAnnoSqlPackage(String annoSqlPackage) {
        this.annoSqlPackage = annoSqlPackage;
    }

    public void addAnnotationConfigFields() {
        long begin = System.currentTimeMillis();
        //获取注解加解密总开关
        if(!isAnnoEnable()){
            return;
        }
        List<String> annoGroupNames = getAnnoGroupNames();
        if(CollectionUtils.isEmpty(annoGroupNames)){
            return;
        }
        //获取实体中的注解
        String annoEntityPackage = getAnnoEntityPackage();
        if(StringUtils.isNotBlank(annoEntityPackage)) {
            Reflections ref = new Reflections(
                    new ConfigurationBuilder()
                            .setUrls(ClasspathHelper.forPackage(annoEntityPackage))
                            .addScanners(new FieldAnnotationsScanner()));
            Set<Field> encryptAnnoFields = ref.getFieldsAnnotatedWith(Encrypt.class);
            List<Map> annoEntityFields = new ArrayList<Map>();
            if (CollectionUtils.isNotEmpty(encryptAnnoFields)) {
                for (Field field : encryptAnnoFields) {
                    Encrypt annotation = field.getAnnotation(Encrypt.class);
                    if (annotation == null || !annoGroupNames.contains(annotation.group())) {//没有值，跳过;组别不对 跳过
                        continue;
                    }
                    Class<?> declaringClass = field.getDeclaringClass();
                    if (declaringClass == null) {
                        continue;
                    }
                    String className = declaringClass.getName();
                    Map map = new HashMap<String, Object>();
                    map.put("entity", className);
                    map.put("field", field.getName());
                    annoEntityFields.add(map);
                }
            }
            if (CollectionUtils.isNotEmpty(annoEntityFields)) {
                if (CollectionUtils.isEmpty(entityFields)) {
                    entityFields = new ArrayList<Map>();
                }
                entityFields.addAll(annoEntityFields);
            }
        }

        //获取sql方法上的注解
        String annoSqlPackage = getAnnoSqlPackage();
        if(StringUtils.isBlank(annoSqlPackage)){
            return;
        }
        Reflections ref = new Reflections(
                new ConfigurationBuilder()
                        .setUrls(ClasspathHelper.forPackage(annoSqlPackage))
                        .addScanners(new MethodAnnotationsScanner()));
        //先获取Encrypt注解
        Set<Method> enctyptMethods = ref.getMethodsAnnotatedWith(Encrypt.class);
        //再获取Encrypts注解
        Set<Method> enctyptArrMethods = ref.getMethodsAnnotatedWith(Encrypts.class);
        if(!CollectionUtils.isNotEmpty(enctyptMethods) && !CollectionUtils.isNotEmpty(enctyptArrMethods)){//没有注解 返回
            return;
        }
        //sql加解密字段
        List<Map> annoSqlFields = new ArrayList<Map>();
        //sql仅加密字段
        List<Map> annoSqlEncryptFields = new ArrayList<Map>();
        //sql仅解密字段
        List<Map> annoSqlDecryptFields = new ArrayList<Map>();
        //sql参数为单独的string,对参数加密（等价于注解）
        List<String> annoSqlSingleEncryptFields = new ArrayList<String>();
        //sql返回值为单独的string,对返回值加密（等价于注解）
        List<String> annoSqlSingleDecryptFields = new ArrayList<String>();
        //处理方法上的Encrypt注解
        if(CollectionUtils.isNotEmpty(enctyptMethods)){
            for (Method method : enctyptMethods) {
                Encrypt annotation = method.getAnnotation(Encrypt.class);
                getFieldsFromAnno(annoSqlFields,annoSqlEncryptFields,annoSqlDecryptFields,annoSqlSingleEncryptFields,
                        annoSqlSingleDecryptFields,method,annotation);
            }
        }
        //处理方法上的Encrypts注解
        if(CollectionUtils.isNotEmpty(enctyptArrMethods)){
            for (Method method : enctyptArrMethods) {
                Encrypts annotation = method.getAnnotation(Encrypts.class);
                Encrypt[] value = annotation.value();
                if(value != null && value.length > 0){
                    for (Encrypt encrypt : value) {
                        getFieldsFromAnno(annoSqlFields,annoSqlEncryptFields,annoSqlDecryptFields,annoSqlSingleEncryptFields,
                                annoSqlSingleDecryptFields,method,encrypt);
                    }
                }
            }
        }
        //预置的sql加解密字段（正向配置）
        if(CollectionUtils.isNotEmpty(annoSqlFields)){
            if(CollectionUtils.isEmpty(sqlFields)){
                sqlFields = new ArrayList<Map>();
            }
            sqlFields.addAll(annoSqlFields);
        }
        //预置的sql加密字段（正向配置）
        if(CollectionUtils.isNotEmpty(annoSqlEncryptFields)){
            if(CollectionUtils.isEmpty(sqlEncryptFields)){
                sqlEncryptFields = new ArrayList<Map>();
            }
            sqlEncryptFields.addAll(annoSqlEncryptFields);
        }
        //预置的sql解密字段（正向配置）
        if(CollectionUtils.isNotEmpty(annoSqlDecryptFields)){
            if(CollectionUtils.isEmpty(sqlDecryptFields)){
                sqlDecryptFields = new ArrayList<Map>();
            }
            sqlDecryptFields.addAll(annoSqlDecryptFields);
        }
        //单一string作为参数加密(正向配置)
        if(CollectionUtils.isNotEmpty(annoSqlSingleEncryptFields)){
            if(CollectionUtils.isEmpty(sqlSingleEncryptFields)){
                sqlSingleEncryptFields = new ArrayList<String>();
            }
            sqlSingleEncryptFields.addAll(annoSqlSingleEncryptFields);
        }
        //单一string作为返回值解密（正向配置）
        if(CollectionUtils.isNotEmpty(annoSqlSingleDecryptFields)){
            if(CollectionUtils.isEmpty(sqlSingleDecryptFields)){
                sqlSingleDecryptFields = new ArrayList<String>();
            }
            sqlSingleDecryptFields.addAll(annoSqlSingleDecryptFields);
        }
        long end = System.currentTimeMillis();
        LOGGER.error("anno scan used time:"+(end-begin));

    }

    /**
     * 同时提供方法和注解参数，便于代码的复用
     * @param annoSqlFields
     * @param annoSqlEncryptFields
     * @param annoSqlDecryptFields
     * @param annoSqlSingleEncryptFields
     * @param annoSqlSingleDecryptFields
     * @param method
     * @param annotation
     */
    private void getFieldsFromAnno(List<Map> annoSqlFields,List<Map> annoSqlEncryptFields,List<Map> annoSqlDecryptFields,
                                   List<String> annoSqlSingleEncryptFields,List<String> annoSqlSingleDecryptFields,Method method,Encrypt annotation){
        if(annotation == null || !annoGroupNames.contains(annotation.group())){
            return;
        }
        String className = method.getDeclaringClass().getName();
        String Fields = annotation.fields();//注解的加解密属性处理
        if(StringUtils.isNotBlank(Fields)){
            String[] split = Fields.split(",");
            if(split != null && split.length > 0){
                for (String s : split) {
                    Map sqlFieldMap = new HashMap<String,Object>();
                    sqlFieldMap.put("mapid",className+"."+method.getName());
                    sqlFieldMap.put("field",s);
                    annoSqlFields.add(sqlFieldMap);
                }
            }
        }
        String encodeFields = annotation.encodeFields();//注解的加密属性处理
        if(StringUtils.isNotBlank(encodeFields)){
            String[] split = encodeFields.split(",");
            if(split != null && split.length > 0){
                for (String s : split) {
                    Map sqlEncryptFieldMap = new HashMap<String, Object>();
                    sqlEncryptFieldMap.put("mapid", className+"."+method.getName());
                    sqlEncryptFieldMap.put("field", s);
                    annoSqlEncryptFields.add(sqlEncryptFieldMap);
                }
            }
        }
        String decodeFields = annotation.decodeFields();//注解的解密属性处理
        if(StringUtils.isNotBlank(decodeFields)){
            String[] split = decodeFields.split(",");
            if(split != null && split.length > 0) {
                for (String s : split) {
                    Map sqlDecryptFieldMap = new HashMap<String, Object>();
                    sqlDecryptFieldMap.put("mapid", className+"."+method.getName());
                    sqlDecryptFieldMap.put("field", s);
                    annoSqlDecryptFields.add(sqlDecryptFieldMap);
                }
            }
        }
        boolean singleEncrypt = annotation.singleEncryptFields();//注解的仅一个参数加密属性
        if(singleEncrypt){
            annoSqlSingleEncryptFields.add(className+"."+method.getName());
        }
        boolean singleDecrypt = annotation.singleDecryptFields();//注解的仅有要给返回值解密属性
        if(singleDecrypt){
            annoSqlSingleDecryptFields.add(className+"."+method.getName());
        }
    }
}
