package cn.gtmap.bdcdj.core.encrypt;


import cn.gtmap.bdcdj.core.encrypt.annotation.Encrypt;
import cn.gtmap.bdcdj.core.encrypt.executor.CryptType;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Intercepts({@Signature(
        type = Executor.class,
        method = "update",
        args = {MappedStatement.class, Object.class}
), @Signature(
        type = Executor.class,
        method = "query",
        args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}
)})
public class EncryptInterceptor implements Interceptor {
    private boolean cryptEnable;
    private CryptProperties cryptProperties;
    @Resource(name = "dbEncryptXmlConfig")
    private DbEncryptXmlConfig dbEncryptXmlConfig;
    public static final ConcurrentHashMap<String, CryptAdapterMatadata> METHOD_ENCRYPT_MAP = new ConcurrentHashMap();

    public CryptProperties getCryptProperties() {
        return cryptProperties;
    }

    public void setCryptProperties(CryptProperties cryptProperties) {
        this.cryptProperties = cryptProperties;
    }

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        if (this.cryptEnable) {
            String mapid = ((MappedStatement) invocation.getArgs()[0]).getId();
            Object[] args = invocation.getArgs();
            CryptAdapterMatadata cryptAdapterMatadata = getEncryptAdapter(args);
            args[1] = cryptAdapterMatadata.encrypt(args[1],mapid);
            Object returnValue = invocation.proceed();
            return cryptAdapterMatadata.decrypt(returnValue,mapid);
        }else{
            return invocation.proceed();
        }
    }

    public CryptAdapterMatadata getEncryptAdapter(Object[] args){
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Class entityClass = null;
        if (args[1] instanceof Map && ((Map)args[1]).containsKey("entityClass")) {
            entityClass = (Class)((Map)args[1]).get("entityClass");
        }

        if (entityClass == null && args[1] instanceof Map && ((Map)args[1]).containsKey("record")) {
            entityClass = ((Map)args[1]).get("record").getClass();
        }
        if (METHOD_ENCRYPT_MAP.contains(mappedStatement.getId()) && METHOD_ENCRYPT_MAP.get(mappedStatement.getId()) != null) {
            return (CryptAdapterMatadata)METHOD_ENCRYPT_MAP.get(mappedStatement.getId());
        } else {
            EncryptAdapterBuilder encryptAdapterBuilder = new EncryptAdapterBuilder(mappedStatement.getId(), entityClass, args[1], cryptProperties);
            CryptAdapterMatadata build = encryptAdapterBuilder.build();
            METHOD_ENCRYPT_MAP.put(mappedStatement.getId(), build);
            return build;
        }
//        EncryptAdapterBuilder encryptAdapterBuilder = new EncryptAdapterBuilder(mappedStatement.getId(), entityClass, args[1], cryptProperties);
//        CryptAdapterMatadata build = encryptAdapterBuilder.build();
//        return build;
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    /**
     * 从配置中初始化加解密参数
     * properties中存储的是xml文件中,id="newEncryptInterceptor"的bean的props
     * dbEncryptXmlConfig类读取配置文件中的数据
     * @param properties
     */
    @Override
    public void setProperties(Properties properties) {
        if(dbEncryptXmlConfig != null && dbEncryptXmlConfig.getConfigUrl() != null && StringUtils.isNotBlank( dbEncryptXmlConfig.getField("CryptType"))) {
            this.cryptEnable = dbEncryptXmlConfig.getBooleanField("DatabaseEncryptEnable");
            String cryptTypeString = dbEncryptXmlConfig.getField("CryptType");
            CryptType cryptType = CryptType.valueOf(cryptTypeString);
            this.cryptProperties = new CryptProperties(this.cryptEnable, cryptType);

            String separator = dbEncryptXmlConfig.getField("Separator");
            if (StringUtils.isNotBlank(separator)) {
                this.cryptProperties.setSeparator(separator);
            }
            String sm4Salt = dbEncryptXmlConfig.getField("Sm4Salt");
            if (StringUtils.isNotBlank(sm4Salt)) {
                this.cryptProperties.setSm4Salt(sm4Salt);
            }
            boolean userSm4KeyEnable = dbEncryptXmlConfig.getBooleanField("UserSm4KeyEnable");
            this.cryptProperties.setUserSm4KeyEnable(userSm4KeyEnable);
            String sm4key = dbEncryptXmlConfig.getField("Sm4key");
            if (StringUtils.isNotBlank(sm4key)) {
                this.cryptProperties.setSm4key(sm4key);
            }
            String encoding = dbEncryptXmlConfig.getField("Encoding");
            if (StringUtils.isNotBlank(encoding)) {
                this.cryptProperties.setEncoding(encoding);
            }
            dbEncryptXmlConfig.getGlobalEnableFields();
            dbEncryptXmlConfig.getGlobalDisableMapFields();
            dbEncryptXmlConfig.getGlobalDisableEntityFields();
            dbEncryptXmlConfig.getSqlFields();
            dbEncryptXmlConfig.getSqlEncryptFields();
            dbEncryptXmlConfig.getSqlDecryptFields();
            dbEncryptXmlConfig.getEntityFields();
            dbEncryptXmlConfig.getSqlSingleEncryptFields();
            dbEncryptXmlConfig.getSqlSingleDecryptFields();
            //添加预置的字段
            dbEncryptXmlConfig.addBaseConfigFields();
            //根据注解获取加解密配置
            dbEncryptXmlConfig.addAnnotationConfigFields();
            this.cryptProperties.setGlobalEnableFields(dbEncryptXmlConfig.getGlobalEnableFields());
            this.cryptProperties.setGlobalDisableMapFields(dbEncryptXmlConfig.getGlobalDisableMapFields());
            this.cryptProperties.setGlobalDisableEntityFields(dbEncryptXmlConfig.getGlobalDisableEntityFields());
            this.cryptProperties.setSqlFields(dbEncryptXmlConfig.getSqlFields());
            this.cryptProperties.setSqlEncryptFields(dbEncryptXmlConfig.getSqlEncryptFields());
            this.cryptProperties.setSqlDecryptFields(dbEncryptXmlConfig.getSqlDecryptFields());
            this.cryptProperties.setEntityFields(dbEncryptXmlConfig.getEntityFields());
            this.cryptProperties.setSqlSingleEncryptFields(dbEncryptXmlConfig.getSqlSingleEncryptFields());
            this.cryptProperties.setSqlSingleDecryptFields(dbEncryptXmlConfig.getSqlSingleDecryptFields());
        }
    }
}
