package cn.gtmap.bdcdj.core.encrypt.adapter.decrypt;

import cn.gtmap.bdcdj.core.encrypt.CryptProperties;
import cn.gtmap.bdcdj.core.encrypt.handler.CryptHandlerFactory;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityHelper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.apache.commons.collections.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CommonDecryptAdapter implements DecryptAdapter{
    private Class entityClass;
    private CryptProperties cryptProperties;
    public CommonDecryptAdapter(Class entityClass, CryptProperties cryptProperties) {
        this.entityClass = entityClass;
        this.cryptProperties = cryptProperties;
    }

    public Object doDecrypt(Object param,String mapid) {
        if (this.entityClass == null || param == null || param instanceof Integer || param instanceof List && CollectionUtils.isNotEmpty((List)param) && ((List)param).get(0) instanceof Integer) {
            return param;
        } else if (param instanceof List) {
            if (CollectionUtils.isEmpty((Collection)param)) {
                return param;
            }else{
                List<Object> resultList = (List<Object>) EntityHelper.maplist2BeanList((List)param, this.entityClass);
                Object res = CryptHandlerFactory.getCryptHandler(resultList).decrypt(resultList, cryptProperties, null);
                return JSON.parseArray(JSON.toJSONString(res, new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}), Map.class);
            }
        }else{
            return CryptHandlerFactory.getCryptHandler(EntityHelper.map2Bean((Map)param, this.entityClass)).decrypt(EntityHelper.map2Bean((Map)param, this.entityClass),cryptProperties,mapid);
        }
    }
}
