package cn.gtmap.bdcdj.core.encrypt.adapter.encrypt;

import cn.gtmap.bdcdj.core.encrypt.CryptProperties;
import cn.gtmap.bdcdj.core.encrypt.LogicalOperatorEnum;
import cn.gtmap.bdcdj.core.encrypt.handler.CryptHandler;
import cn.gtmap.bdcdj.core.encrypt.handler.CryptHandlerFactory;
import cn.gtmap.bdcdj.core.encrypt.handler.ListCryptHandler;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperMethod;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommonEncryptAdapter implements EncryptAdapter {
    private Method method;
    private String name;
    private CryptProperties cryptProperties;


    public CommonEncryptAdapter(Method method, CryptProperties cryptProperties) {
        this.method = method;
        this.name = method.getName();
        this.cryptProperties = cryptProperties;
    }
    @Override
    public Object doEnctypt(Object param,String mapid) {
        if (param == null) {
            return null;
        } else if (StringUtils.containsIgnoreCase(this.name, "example")) {
            param = this.doExampleEncrypt(param,mapid);
            return this.doUpdateSelectiveEncrypt(param,mapid);//updateByExampleSelective 时，不仅要修改example中的值，还要修改实体中的值。（原逻辑使用实体注解实现，没有这个逻辑）
        }
//        else if(StringUtils.containsIgnoreCase(this.name, "selectByPrimaryKey")){
//            return this.doSelectiveEncryptByPrimaryKey(param,mapid);
//        }
        else if (!StringUtils.containsIgnoreCase(this.name, "insert") && !StringUtils.containsIgnoreCase(this.name, "update")) {
            if (this.name.equalsIgnoreCase("insertBatchSelective")) {
                return this.doInsertBatchSelectiveEncrypt(param,mapid);
            } else {
                return this.name.equalsIgnoreCase("updateByPrimaryKeySelective") ? this.doUpdateByPrimaryKeySelectiveEncrypt(param,mapid) : param;
            }
        }
        else {
            return this.doInsertSelectiveEncrypt(param,mapid);
        }
    }

    private Object doUpdateSelectiveEncrypt(Object param, String mapid) {
        Map paramMap = (Map)param;
        if(paramMap.containsKey("record")) {
            Object record = paramMap.get("record");
            Object encryptRecord = CryptHandlerFactory.getCryptHandler(record).encrypt(record, this.cryptProperties, mapid);
            paramMap.put("record", encryptRecord);
            paramMap.put("param1", encryptRecord);
        }
        return paramMap;
    }

    private Object doUpdateByPrimaryKeySelectiveEncrypt(Object param,String mapid) {
        return this.doInsertSelectiveEncrypt(param,mapid);
    }
    private Object doInsertBatchSelectiveEncrypt(Object param,String mapid) {
        return this.doInsertSelectiveEncrypt(param,mapid);
    }

    private Object doInsertSelectiveEncrypt(Object param,String mapid) {
        Object record = ((Map)param).get("record");
        Object encryptRecord = CryptHandlerFactory.getCryptHandler(record).encrypt(record,  this.cryptProperties, mapid);
        Map parammap = new MapperMethod.ParamMap();
        parammap.put("record", encryptRecord);
        parammap.put("param1", encryptRecord);
        return parammap;
    }
    private Object doSelectiveEncryptByPrimaryKey(Object param,String mapid) {
        Object record = ((Map)param).get("param2");
        Object encryptRecord = CryptHandlerFactory.getCryptHandler(record).encrypt(record,  this.cryptProperties, mapid);
        Map parammap = new MapperMethod.ParamMap();
        parammap.put("key", encryptRecord);
        parammap.put("param2", encryptRecord);
        return parammap;
    }

    private Object doExampleEncrypt(Object param,String mapid) {
        if (param instanceof Map && ((Map)param).containsKey("example")) {
            Example example = (Example) ((Map)param) .get("example");
            Class entityclass = example.getEntityClass();
            if (entityclass == null && ((Map)param).containsKey("entityClass")) {
                entityclass = (Class)((Map)param).get("entityClass");
            }

            if (CollectionUtils.isEmpty(example.getOredCriteria())) {
                return param;
            }

            Field[] fields = entityclass.getDeclaredFields();
            if (ArrayUtils.isEmpty(fields)) {
                return param;
            }


            /*Map<String, Crypt> cryptFieldMap = this.getCryptFieldMap(fields);
            if (MapUtils.isEmpty(cryptFieldMap)) {
                return param;
            }
            Map<String, Crypt> needCryptFieldMap = this.getNeedCryptFieldMap(cryptFieldMap, example);
            if (MapUtils.isEmpty(needCryptFieldMap)) {
                return param;
            }*/
            List<String> cryptFieldList =  this.getCryptFieldList(fields,entityclass);
            if(CollectionUtils.isEmpty(cryptFieldList)) {
                return param;
            }
            

            Example newExample = this.convertEncryptValue(example, cryptFieldList,mapid);
            ((Map)param).put("example", newExample);
            ((Map)param).put("param2", newExample);
        }

        return param;
    }

    private Example convertEncryptValue(Example example, List<String> cryptFieldList, String mapid) {
        Example newExample = new Example(example.getEntityClass());
        newExample.setOrderByClause(example.getOrderByClause());
        newExample.setDistinct(example.isDistinct());
        List<Example.Criteria> oredCriteria = example.getOredCriteria();
        if(CollectionUtils.isNotEmpty(oredCriteria)){
            for (Example.Criteria criteria : oredCriteria) {
                if(criteria.isValid()) {
                    Example.Criteria newCriteria = newExample.createCriteria();
                    List<Example.Criterion> criterionList = criteria.getCriteria();
                    if(CollectionUtils.isNotEmpty(criterionList)){
                        for (Example.Criterion criterion : criterionList) {
                            boolean matchField = false;
                            String logicalOperatorEnum = this.matchLogicalOperator(criterion);
                            if(StringUtils.isNotBlank(logicalOperatorEnum)){
                                int index = criterion.getCondition().lastIndexOf(logicalOperatorEnum);
                                String fieldName = criterion.getCondition().substring(0, index).toLowerCase();
                                if(cryptFieldList.contains(fieldName)){//需要加密  因为example中传递的参数并没有mapper类型 ，所以这里不会使用到mapid，传空值
                                    if(StringUtils.equals(LogicalOperatorEnum.andEqualTo.getOperator(),logicalOperatorEnum)){
                                        newCriteria.andEqualTo(fieldName, CryptHandlerFactory.getCryptHandler(criterion.getValue()).encrypt(criterion.getValue(), this.cryptProperties,mapid));
                                        matchField = true;
                                        continue;
                                    }
                                    if(StringUtils.equals(LogicalOperatorEnum.andNotEqualTo.getOperator(),logicalOperatorEnum)){
                                        newCriteria.andEqualTo(fieldName, CryptHandlerFactory.getCryptHandler(criterion.getValue()).encrypt(criterion.getValue(), this.cryptProperties,mapid));
                                        matchField = true;
                                        continue;
                                    }
                                    CryptHandler cryptHandler;
                                    ListCryptHandler listCryptHandler;
                                    if(StringUtils.equals(LogicalOperatorEnum.andNotIn.getOperator(),logicalOperatorEnum)){
                                        cryptHandler = CryptHandlerFactory.getCryptHandler(criterion.getValue());
                                        if(cryptHandler instanceof ListCryptHandler){
                                            listCryptHandler = (ListCryptHandler) cryptHandler;
                                            newCriteria.andNotIn(fieldName,listCryptHandler.doEncryptList((List)criterion.getValue(),this.cryptProperties,mapid));
                                            matchField = true;
                                        }
                                        continue;
                                    }
                                    if(StringUtils.equals(LogicalOperatorEnum.andIn.getOperator(),logicalOperatorEnum)){
                                        cryptHandler = CryptHandlerFactory.getCryptHandler(criterion.getValue());
                                        if(cryptHandler instanceof ListCryptHandler){
                                            listCryptHandler = (ListCryptHandler) cryptHandler;
                                            newCriteria.andIn(fieldName,listCryptHandler.doEncryptList((List)criterion.getValue(),this.cryptProperties,mapid));
                                            matchField = true;
                                        }
                                        continue;
                                    }
                                    if(StringUtils.equals(LogicalOperatorEnum.andNotLike.getOperator(),logicalOperatorEnum)){
                                        newCriteria.andNotLike(fieldName,String.valueOf(CryptHandlerFactory.getCryptHandler(criterion.getValue()).encrypt(criterion.getValue(),this.cryptProperties,mapid)));
                                        matchField = true;
                                        continue;
                                    }
                                    if(StringUtils.equals(LogicalOperatorEnum.andLike.getOperator(),logicalOperatorEnum)){
                                        newCriteria.andLike(fieldName,String.valueOf(CryptHandlerFactory.getCryptHandler(criterion.getValue()).encrypt(criterion.getValue(),this.cryptProperties,mapid)));
                                        matchField = true;
                                        continue;
                                    }
                                }
                            }
                            if(!matchField){
                                newCriteria.getCriteria().add(criterion);
                            }
                        }
                    }
                }
            }
        }
        return newExample;
    }

    private List<String> getCryptFieldList(Field[] fields,Class entityclass) {
        if(fields != null && fields.length > 0){
            List<String> result = new ArrayList<String>();
            String entityName = entityclass.getName();
            for (Field field : fields) {
                if(cryptProperties.isEncryptDecryptEntityField(entityName,field.getName())){
                    result.add(field.getName());
                }
            }
            return result;
        }else{
            return new ArrayList<String>();
        }
    }

    private String matchLogicalOperator(Example.Criterion criterion) {
        LogicalOperatorEnum[] logicalOperatorEnums = LogicalOperatorEnum.values();
        LogicalOperatorEnum[] var3 = logicalOperatorEnums;
        int var4 = logicalOperatorEnums.length;

        for(int var5 = 0; var5 < var4; ++var5) {
            LogicalOperatorEnum logicalOperatorEnum = var3[var5];
            if (criterion.getCondition().lastIndexOf(logicalOperatorEnum.getOperator()) > 0) {
                return logicalOperatorEnum.getOperator();
            }
        }

        return "";
    }

}
