package cn.gtmap.bdcdj.core.encrypt.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.FIELD})//方法和字段都可以使用
public @interface Encrypt {
    //分组 分组之后才能进行加解密
    String group();
    //方法上使用的字段 对sql中的字段进行加解密
    String fields() default "";
    //方法上使用的字段 对sql中入参的字段进行加密
    String encodeFields() default "";
    //方法上使用的字段 对sql中返回值的字段进行解密
    String decodeFields() default "";
    //方法上使用的字段 在只有一个参数时加密
    boolean singleEncryptFields() default false;
    //方法上使用的字段 在只有一个参数时解密
    boolean singleDecryptFields() default false;
}
