package cn.gtmap.bdcdj.core.encrypt.config;

import java.util.List;
import java.util.Map;

/**
 * 预置字段，可以通过在BaseConfigOptions配置中配置直接添加预设好的加解密字段
 * 出于统一优先级设计考虑，目前设计预置字段只进行添加处理，没有排除例外字段的功能
 */
public interface BaseConfig {
    //全局加密字段 正向
    List<String> getGlobalEnableFields();
    //sql加解密字段 正向
    List<Map> getSqlFields();
    //sql加密字段 正向
    List<Map> getSqlEncryptFields();
    //sql解密字段 正向
    List<Map> getSqlDecryptFields();
    //实体加解密字段 正向
    List<Map> getEntityFields();
    //单一string作为参数加密 正向
    List<String> getSqlSingleEncryptFields();
    //单一string作为返回值解密 正向
    List<String> getSqlSingleDecryptFields();

    //全局加密字段在sql中的反向配置（配置在其中的不进行加解密处理） 反向
    List<Map> getGlobalDisableMapFields();
    //全局加密字段在entity中的反向配置（配置在其中的不进行加解密处理） 反向
    List<Map> getGlobalDisableEntityFields();

}
