package cn.gtmap.bdcdj.core.encrypt.executor;

import cn.gtmap.bdcdj.core.encrypt.CryptProperties;
import cn.gtmap.bdcdj.core.encrypt.enums.SaltsEnum;
import cn.gtmap.bdcdj.core.encrypt.utils.AESutil;
import cn.gtmap.bdcdj.core.encrypt.utils.CryptUtil;
import org.apache.commons.lang3.StringUtils;

/**
 * AES CBC 加密解密
 *
 */
public class AesCryptExecutor implements CryptExecutor {


    @Override
    public String encrypt(CryptProperties cryptProperties, String value) {
        if (StringUtils.isBlank(value)) {
            return value;
        }
        if (StringUtils.startsWithIgnoreCase(value, SaltsEnum.SALTS.getSalt())) {
            return value;
        }
        String separatorChars = CryptUtil.getSeparatorChars(value);
        if (StringUtils.isNotEmpty(separatorChars)) {
            String[] paramArray = StringUtils.split(value, separatorChars);
            StringBuilder encryptParam = new StringBuilder();
            for (String temp : paramArray) {
                encryptParam.append(CryptUtil.matchHex(temp) ? temp : AESutil.encodeToHexString(temp)).append(separatorChars);
            }
            return StringUtils.substring(encryptParam.toString(), 0, encryptParam.length() - 1);
        }
        return AESutil.encodeToHexString(value);
    }

    @Override
    public String decrypt(CryptProperties cryptProperties, String param) {
        if (StringUtils.isBlank(param)) {
            return param;
        }
        try {
            String separatorChars = CryptUtil.getSeparatorChars(param);
            if (StringUtils.isNotEmpty(separatorChars)) {
                String[] paramArray = StringUtils.split(param, separatorChars);
                StringBuilder decryptParam = new StringBuilder();
                for (String temp : paramArray) {
                    decryptParam.append(CryptUtil.matchHex(temp) ? AESutil.decodeFromHexString(temp) : temp).append(separatorChars);
                }
                return StringUtils.substring(decryptParam.toString(), 0, decryptParam.length() - 1);
            }
            if (CryptUtil.matchHex(param)) {
                return AESutil.decodeFromHexString(param);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return param;
    }
}
