package cn.gtmap.bdcdj.core.encrypt.executor;



import cn.gtmap.bdcdj.core.encrypt.CryptProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CryptExecutorFactory {
    private static Map<CryptType, CryptExecutor> cryptExecutorMap = new ConcurrentHashMap(4);
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptExecutorFactory.class);

    public CryptExecutorFactory() {
    }

    private static void registerCryptExcutor() {
        cryptExecutorMap.put(CryptType.AES_CBC, new AesCryptExecutor());
//        cryptExecutorMap.put(CryptType.GM_SM2, new GmSm2CryptExecutor());
        cryptExecutorMap.put(CryptType.GM_SM4, new GmSm4CryptExecutor());
    }

    public static CryptExecutor getTypeHandler(CryptProperties cryptProperties) {
        CryptType chooseType =  cryptProperties.getCryptType();
        if (cryptExecutorMap.containsKey(chooseType)) {
            CryptExecutor cryptExecutor = (CryptExecutor)cryptExecutorMap.get(chooseType);
            return cryptExecutor;
        } else {
            LOGGER.error(chooseType + "has no matched CryptExcutor");
            return null;
        }
    }

    static {
        registerCryptExcutor();
    }
}
