package cn.gtmap.bdcdj.core.encrypt.executor;

import cn.gtmap.bdcdj.core.encrypt.CryptProperties;
import cn.gtmap.bdcdj.core.encrypt.utils.CryptUtil;
import cn.gtmap.bdcdj.core.encrypt.utils.GmSm4Util;
import org.apache.commons.lang3.StringUtils;

public class GmSm4CryptExecutor implements CryptExecutor {
    public GmSm4CryptExecutor() {
    }

    @Override
    public String encrypt(CryptProperties cryptProperties, String decryptString) {
        if (StringUtils.isBlank(decryptString)) {
            return decryptString;
        } else if (StringUtils.isNotEmpty(cryptProperties.getSm4Salt()) && StringUtils.startsWithIgnoreCase(decryptString, cryptProperties.getSm4Salt())) {
            return decryptString;
        } else {
            String separatorChars = CryptUtil.getSeparatorChars(decryptString);
            if (StringUtils.isNotEmpty(cryptProperties.getSeparator()) && !StringUtils.equalsIgnoreCase(separatorChars, cryptProperties.getSeparator())) {
                separatorChars = cryptProperties.getSeparator();
            }

            if (!StringUtils.isNotEmpty(separatorChars)) {
                return GmSm4Util.encryptEcb(decryptString, cryptProperties);
            } else {
                String[] paramArray = StringUtils.split(decryptString, separatorChars);
                StringBuilder encryptParam = new StringBuilder();
                String[] var6 = paramArray;
                int var7 = paramArray.length;

                for(int var8 = 0; var8 < var7; ++var8) {
                    String temp = var6[var8];
                    encryptParam.append(GmSm4Util.encryptEcb(temp, cryptProperties)).append(separatorChars);
                }

                return StringUtils.substring(encryptParam.toString(), 0, encryptParam.length() - 1);
            }
        }
    }

    public static String encrypt(String decryptString) {
        if (StringUtils.isBlank(decryptString)) {
            return decryptString;
        } else if (StringUtils.startsWithIgnoreCase(decryptString, "4mspamtg")) {
            return decryptString;
        } else {
            String separatorChars = CryptUtil.getSeparatorChars(decryptString);

            if (!StringUtils.isNotEmpty(separatorChars)) {
                return GmSm4Util.encryptEcb(decryptString);
            } else {
                String[] paramArray = StringUtils.split(decryptString, separatorChars);
                StringBuilder encryptParam = new StringBuilder();
                String[] var6 = paramArray;
                int var7 = paramArray.length;

                for(int var8 = 0; var8 < var7; ++var8) {
                    String temp = var6[var8];
                    encryptParam.append(GmSm4Util.encryptEcb(temp)).append(separatorChars);
                }

                return StringUtils.substring(encryptParam.toString(), 0, encryptParam.length() - 1);
            }
        }
    }

    private static boolean needDecrypt(String data,CryptProperties cryptProperties) {
        if (StringUtils.isNotBlank(cryptProperties.getSm4Salt())  ) {
            if(StringUtils.startsWithIgnoreCase(data, cryptProperties.getSm4Salt())){
                return true;
            }else{
                return false;
            }
        } else {
            return true;
        }
    }
    @Override
    public String decrypt(CryptProperties cryptProperties, String encrytString) {
        if (StringUtils.isBlank(encrytString)) {
            return encrytString;
        } else if (!needDecrypt(encrytString, cryptProperties)) {
            return encrytString;
        }else{
            try {
                String separatorChars = CryptUtil.getSeparatorChars(encrytString);
                if (StringUtils.isNotEmpty(cryptProperties.getSeparator()) && !StringUtils.equalsIgnoreCase(separatorChars, cryptProperties.getSeparator())) {
                    separatorChars = cryptProperties.getSeparator();
                }

                if (!StringUtils.isNotEmpty(separatorChars)) {
                    return GmSm4Util.decryptEcb(encrytString, cryptProperties);
                } else {
                    String[] paramArray = StringUtils.split(encrytString, separatorChars);
                    StringBuilder decryptParam = new StringBuilder();
                    String[] var6 = paramArray;
                    int var7 = paramArray.length;

                    for(int var8 = 0; var8 < var7; ++var8) {
                        String temp = var6[var8];
                        decryptParam.append(GmSm4Util.decryptEcb(temp, cryptProperties)).append(separatorChars);
                    }

                    return StringUtils.substring(decryptParam.toString(), 0, decryptParam.length() - 1);
                }
            } catch (Exception var10) {
                var10.printStackTrace();
                return encrytString;
            }
        }
    }

    public static String decrypt(String encrytString) {
        if (StringUtils.isBlank(encrytString)) {
            return encrytString;
        } else if (!StringUtils.startsWithIgnoreCase(encrytString, "4mspamtg")) {
            return encrytString;
        }else{
            try {
                String separatorChars = CryptUtil.getSeparatorChars(encrytString);
                if (!StringUtils.isNotEmpty(separatorChars)) {
                    return GmSm4Util.decryptEcb(encrytString);
                } else {
                    String[] paramArray = StringUtils.split(encrytString, separatorChars);
                    StringBuilder decryptParam = new StringBuilder();
                    String[] var6 = paramArray;
                    int var7 = paramArray.length;

                    for(int var8 = 0; var8 < var7; ++var8) {
                        String temp = var6[var8];
                        decryptParam.append(GmSm4Util.decryptEcb(temp)).append(separatorChars);
                    }

                    return StringUtils.substring(decryptParam.toString(), 0, decryptParam.length() - 1);
                }
            } catch (Exception var10) {
                var10.printStackTrace();
                return encrytString;
            }
        }
    }
}
