package cn.gtmap.bdcdj.core.encrypt.handler;

import cn.gtmap.bdcdj.core.encrypt.CryptProperties;

/**
 * 列表只需要将每个元素进行加解密，不需要获取加解密字段
 */
public class ArrayCryptHandler implements CryptHandler<Object>  {

    @Override
    public Object encrypt(Object object, CryptProperties cryptProperties,String mapid) {
        if (object == null) {
            return null;
        } else {
            Object[] arrs = (Object[])((Object[])object);
            Object[] result = new Object[arrs.length];

            for(int a = 0; a < arrs.length; ++a) {
                result[a] = CryptHandlerFactory.getCryptHandler(arrs[a]).encrypt(arrs[a], cryptProperties,mapid);
            }

            return result;
        }
    }

    @Override
    public Object decrypt(Object param, CryptProperties cryptProperties,String mapid) {
        if (param == null) {
            return null;
        } else {
            Object[] arrs = (Object[])((Object[])param);
            Object[] result = new Object[arrs.length];

            for(int a = 0; a < arrs.length; ++a) {
                result[a] = CryptHandlerFactory.getCryptHandler(arrs[a]).decrypt(arrs[a], cryptProperties,mapid);
            }

            return result;
        }
    }
}
