package cn.gtmap.bdcdj.core.encrypt.handler;


import cn.gtmap.bdcdj.core.encrypt.CryptProperties;
import cn.gtmap.bdcdj.core.encrypt.DbEncryptXmlConfig;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * bean中获取加解密字段
 */
@Component
public class BeanCryptHandler implements CryptHandler<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanCryptHandler.class);
    @Override
    public Object encrypt(Object bean, CryptProperties cryptProperties,String mapid) {
        if (bean == null) {
            return null;
        } else {
            Object result = null;
            try {
                result = BeanUtils.cloneBean(bean);
            } catch (Exception var11) {
                LOGGER.error("BeanCryptHandler.encrypt.getresult"+var11.getMessage());
            }

            List<Field> fieldList = this.getEncryptDecryptFields(result.getClass(),cryptProperties);
            if (CollectionUtils.isEmpty(fieldList)) {
                return bean;
            } else {
                for (Field field : fieldList) {
                    try {
                        field.setAccessible(true);
                        Object o = field.get(result);
                        if(o != null){
                            Object encrypted = CryptHandlerFactory.getCryptHandler(o).encrypt(o, cryptProperties,mapid);
                            field.set(result,encrypted);
                        }
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                        LOGGER.error("BeanCryptHandler.encrypt.getfield"+e.getMessage());
                    }
                }

                return result;
            }
        }
    }


    @Override
    public Object decrypt(Object param, CryptProperties cryptProperties,String mapid) {
        if (param == null) {
            return null;
        } else {
            List<Field> fieldList = this.getEncryptDecryptFields(param.getClass(),cryptProperties);
            if(CollectionUtils.isNotEmpty(fieldList)){
                for (Field field : fieldList) {
                    try {
                        field.setAccessible(true);
                        Object o = field.get(param);
                        if(o != null){
                            Object decrypt = CryptHandlerFactory.getCryptHandler(o).decrypt(o, cryptProperties,mapid);
                            field.set(param,decrypt);
                        }
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                        LOGGER.error("BeanCryptHandler.decrypt"+e.getMessage());
                    }
                }
            }

            return param;
        }
    }

    //对bean来说，加密字段和解密字段应该一致
    private List<Field> getEncryptDecryptFields(Class clazz, CryptProperties cryptProperties) {
        List<Field> fieldList = new ArrayList();
        if (clazz == null) {
            return fieldList;
        } else {
            Field[] fields = clazz.getDeclaredFields();
            String fieldName = "";
            String className = clazz.getName();
            if(fields != null && fields.length > 0){
                for (Field field : fields) {
                    fieldName = field.getName();
                    if(cryptProperties.isEncryptDecryptEntityField(className,fieldName)){
                        fieldList.add(field);
                    }
                }
            }
            return fieldList;
        }
    }
}
