package cn.gtmap.bdcdj.core.encrypt.handler;

import cn.gtmap.bdcdj.core.encrypt.enums.HandlerKeyEnum;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CryptHandlerFactory {
    private static Map<String, CryptHandler> handlerMap = new ConcurrentHashMap(6);

    public CryptHandlerFactory() {
    }

    private static void registHandler() {
        handlerMap.put(HandlerKeyEnum.EMPTY_HANDLER.getKey(), new EmptyCryptHandler());
        handlerMap.put(HandlerKeyEnum.STRING_HANDLER.getKey(), new StringCryptHandler());
        handlerMap.put(HandlerKeyEnum.LIST_HANDLER.getKey(), new ListCryptHandler());
        handlerMap.put(HandlerKeyEnum.ARRAY_HANDLER.getKey(), new ArrayCryptHandler());
        handlerMap.put(HandlerKeyEnum.BEAN_HANDLER.getKey(), new BeanCryptHandler());
        handlerMap.put(HandlerKeyEnum.MAP_HANDLER.getKey(), new MapCryptHandler());
    }

    public static CryptHandler getCryptHandler(Object obj) {
        String hanlerKey = gethandlerKey(obj);
        return handlerMap.get(hanlerKey);
    }

    private static String gethandlerKey(Object obj) {
        if (obj != null) {
            if (obj instanceof String && StringUtils.isBlank((String)obj)) {
                return HandlerKeyEnum.EMPTY_HANDLER.getKey();
            } else if (obj instanceof Map) {
                return HandlerKeyEnum.MAP_HANDLER.getKey();
            } else if (obj instanceof String) {
                return HandlerKeyEnum.STRING_HANDLER.getKey();
            } else if (obj instanceof List) {
                return HandlerKeyEnum.LIST_HANDLER.getKey();
            } else {
                return obj.getClass().isArray() ? HandlerKeyEnum.LIST_HANDLER.getKey() : HandlerKeyEnum.BEAN_HANDLER.getKey();
            }
        } else {
            return HandlerKeyEnum.EMPTY_HANDLER.getKey();
        }
    }

    static {
        registHandler();
    }
}
