package cn.gtmap.bdcdj.core.encrypt.handler;


import cn.gtmap.bdcdj.core.encrypt.CryptProperties;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

public class ListCryptHandler implements CryptHandler<Object> {
    @Override
    public Object encrypt(Object param, CryptProperties cryptProperties,String mapid) {
        List<Object> list = (List)param;
//        return this.doReturn(list) ? list : this.doEncryptList( list,cryptProperties,mapid);
        return this.doEncryptList( list,cryptProperties,mapid);
    }

    @Override
    public Object decrypt(Object param, CryptProperties cryptProperties,String mapid) {
        List<Object> list = (List)param;
//        if (this.doReturn(list)) {//doreturn： 在list中为基础数据类型时，不进行加解密，此处去除此逻辑
//            return param;
//        }else{
            try{
                List result = new ArrayList(list.size());
                if(CollectionUtils.isNotEmpty(list)){
                    for (Object o : list) {
                        result.add(CryptHandlerFactory.getCryptHandler(o).decrypt(o, cryptProperties,mapid));
                    }
                }
                return result;
            }catch (Exception e){
                e.printStackTrace();
                return param;
            }
//        }
    }

    public List doEncryptList( List<Object> list,CryptProperties cryptProperties,String mapid) {
        List result = null;

        try {
            result = (List)list.getClass().newInstance();
        } catch (Exception e) {
            e.printStackTrace();
            result = this.retryNewInstance(list);
        }

        try {
            if(CollectionUtils.isNotEmpty(list)){
                for (Object o : list) {
                    result.add(CryptHandlerFactory.getCryptHandler(o).encrypt(o,cryptProperties,mapid));
                }
            }
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            return list;
        }
    }

    private boolean doReturn(List<Object> list) {
        if (CollectionUtils.isEmpty(list)) {
            return true;
        } else{
            return (list.get(0) instanceof String || list.get(0) instanceof Integer || list.get(0) instanceof Double || list.get(0) instanceof Float);
        }
    }


    private List retryNewInstance(List<Object> list) {
        return new ArrayList();
    }
}
