package cn.gtmap.bdcdj.core.encrypt.handler;

import cn.gtmap.bdcdj.core.encrypt.CryptProperties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapCryptHandler implements CryptHandler{
    @Override
    public Object encrypt(Object param, CryptProperties cryptProperties,String mapid) {
        Map map = (Map)param;
        List<String> encryptKeyList =getMapEncryptKeys(map,mapid,cryptProperties);
        if(CollectionUtils.isEmpty(encryptKeyList)){
            return param;
        }else{
            Map encryptParam = new LinkedCaseInsensitiveMap(map.size());
            Set<Map.Entry> set = map.entrySet();
            if(CollectionUtils.isNotEmpty(set)){
                for (Map.Entry entry : set) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if(encryptKeyList.contains(key.toLowerCase())){
                        encryptParam.put(key,CryptHandlerFactory.getCryptHandler(value).encrypt(value,cryptProperties,mapid));
                    }else{
                        encryptParam.put(key,value);
                    }
                }
            }
            return encryptParam;
        }
    }

    private List<String> getMapEncryptKeys(Map map, String mapid, CryptProperties cryptProperties) {
        List<String> result = new ArrayList<String>();
        if(StringUtils.isBlank(mapid)){//没有任何情况下，会有没有id的map被加密，即使是全局加解密
            return result;
        }else {
            if (MapUtils.isNotEmpty(map)) {
                Set set = map.keySet();
                if(CollectionUtils.isNotEmpty(set)){
                    for (Object o : set) {
                        String key = (String) o;
                        if(cryptProperties.isEncryptMapField(mapid,key)){
                            result.add(key);
                        }
                    }
                }
            }
            return result;
        }
    }

    @Override
    public Object decrypt(Object param, CryptProperties cryptProperties,String mapid) {
        Map map = (Map)param;
        List<String> decryptKeyList =getMapDecryptKeys(map,mapid,cryptProperties);
        if(CollectionUtils.isEmpty(decryptKeyList)){
            return param;
        }else{
            Map decryptParam = new LinkedCaseInsensitiveMap(map.size());
            Set<Map.Entry> set = map.entrySet();
            if(CollectionUtils.isNotEmpty(set)){
                for (Map.Entry entry : set) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if(decryptKeyList.contains(key.toLowerCase()) || decryptKeyList.contains(key)){
                        decryptParam.put(key,CryptHandlerFactory.getCryptHandler(value).decrypt(value,cryptProperties,mapid));
                    }else{
                        decryptParam.put(key,value);
                    }
                }
            }
            return decryptParam;
        }
    }

    private List<String> getMapDecryptKeys(Map map, String mapid, CryptProperties cryptProperties) {
        List<String> result = new ArrayList<String>();
        if(StringUtils.isBlank(mapid)){//没有任何情况下，会有没有id的map被加密，即使是全局加解密
            return result;
        }else {
            if (MapUtils.isNotEmpty(map)) {
                Set set = map.keySet();
                if(CollectionUtils.isNotEmpty(set)){
                    for (Object o : set) {
                        String key = (String) o;
                        if(cryptProperties.isDecryptMapField(mapid,key)){
                            result.add(key);
                        }
                    }
                }
            }
            return result;
        }
    }
}
