package cn.gtmap.bdcdj.core.encrypt.port;

import cn.gtmap.bdcdj.core.encrypt.DbEncryptXmlConfig;
import cn.gtmap.bdcdj.core.encrypt.utils.GmSm2Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.UrlPathHelper;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;

/**
 * 使用HttpServletRequestWrapper包装，后续处理时，返回新的body
 */
public class DecryptHttpServletRequestWrapper extends HttpServletRequestWrapper {

    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    //保存流中的数据request.getInputStream()中的数据
    private String body;
    public DecryptHttpServletRequestWrapper(HttpServletRequest request,DbEncryptXmlConfig dbEncryptXmlConfig)
            throws Exception {
        super(request);
        //从流中获取数据
        this.body=IOUtils.toString(request.getInputStream(), StandardCharsets.UTF_8);

        if(StringUtils.isEmpty(body)) {
            body = "";
        }else{
            //解密报文体先存起来，后面重新放入
            String path = urlPathHelper.getLookupPathForRequest(request);
            List<String> interfaceEncryptList = dbEncryptXmlConfig.getInterfaceEncryptList();
            String decodeKey = dbEncryptXmlConfig.getInterfaceSm2DecodeKey();
            if(isNeedDecrypt(path,interfaceEncryptList)) {
                body = GmSm2Util.decrypt(body, decodeKey, "");
            }
        }
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        // 必须指定utf-8编码，否则json请求数据中如果包含中文，会出现异常
        final ByteArrayInputStream byteArrayInputStream =
                new ByteArrayInputStream(body.getBytes("utf-8"));
        ServletInputStream servletInputStream = new ServletInputStream() {
            @Override
            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
        return servletInputStream;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getInputStream()));
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }
    private boolean isNeedDecrypt(String path,List<String> interfaceEncryptList) {
        boolean result = false;
        if(StringUtils.isNotBlank(path) && CollectionUtils.isNotEmpty(interfaceEncryptList)){
            PathMatcher pathMatcher = new AntPathMatcher();
            for (String pattern : interfaceEncryptList) {
                if(pathMatcher.match(pattern, path)){
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
}