package cn.gtmap.bdcdj.core.encrypt.port;

import cn.gtmap.bdcdj.core.encrypt.DbEncryptXmlConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
public class InterfaceDecryptFilter implements Filter {
    private DbEncryptXmlConfig dbEncryptXmlConfig;

    public void setDbEncryptXmlConfig(DbEncryptXmlConfig dbEncryptXmlConfig) {
        this.dbEncryptXmlConfig = dbEncryptXmlConfig;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        //filter中无法进行注入，需要从上下文中获取
        ServletContext context = filterConfig.getServletContext();
        ApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(context);
        dbEncryptXmlConfig = (DbEncryptXmlConfig) ctx.getBean("dbEncryptXmlConfig");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if(dbEncryptXmlConfig.getBooleanField("InterfaceDecryptEnable")) {
            try {
                DecryptHttpServletRequestWrapper requestWrapper =
                        new DecryptHttpServletRequestWrapper((HttpServletRequest) request, dbEncryptXmlConfig);
                chain.doFilter(requestWrapper, response);
            } catch (Exception e) {
                throw new ServletException();
            }
        }else{
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {

    }
}
