package cn.gtmap.bdcdj.core.encrypt.port;

import cn.gtmap.bdcdj.core.encrypt.DbEncryptXmlConfig;
import cn.gtmap.bdcdj.core.encrypt.utils.GmSm2Util;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UrlPathHelper;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.util.List;

public class InterfaceEcnryptAspect {
    Logger logger = LoggerFactory.getLogger(InterfaceEcnryptAspect.class);
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    @Resource(name = "dbEncryptXmlConfig")
    private DbEncryptXmlConfig dbEncryptXmlConfig;
    private boolean cryptEnable;

    public boolean isCryptEnable() {
        return cryptEnable;
    }

    public void setCryptEnable(boolean cryptEnable) {
        this.cryptEnable = cryptEnable;
    }

    public Object aroundExecute(ProceedingJoinPoint joinPoint) throws Throwable{
        Object returnObj = null;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if(requestAttributes != null && dbEncryptXmlConfig.getBooleanField("InterfaceEncryptEnable")) {
            List<String> interfaceEncryptList = dbEncryptXmlConfig.getInterfaceEncryptList();
            HttpServletRequest request = requestAttributes.getRequest();
            String path = urlPathHelper.getLookupPathForRequest(request);
            String declaringTypeName = joinPoint.getSignature().getDeclaringTypeName();

            if(isNeedDecrypt(path,interfaceEncryptList)) {//
                returnObj = joinPoint.proceed();
                if(logger.isDebugEnabled()) {
                    logger.debug("result : " + JSON.toJSONString(returnObj));
                }
                String encodeKey = dbEncryptXmlConfig.getInterfaceSm2EncodeKey();
                if(StringUtils.isNotBlank(encodeKey) && isController(declaringTypeName)){
                    String res = GmSm2Util.encrypt(JSON.toJSONString(returnObj), encodeKey, "");
                    if (returnObj instanceof JSONObject) {//登记程序中，只使用了fastjson的jsonobj
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("result",res);
                        returnObj = jsonObject;
                    }else if(returnObj instanceof String){//可以将返回值为jsonobject的，或者string的加解密成本身的结构并返回，其他结构无法做到
                        returnObj = res;
                    }
                    logger.debug("result after encrypt: " + JSON.toJSONString(returnObj));
                }
            }else{
                returnObj = joinPoint.proceed();
            }
        }else{
            returnObj = joinPoint.proceed();
        }
        return returnObj;

    }

    private boolean isNeedDecrypt(String path,List<String> interfaceEncryptList) {
        boolean result = false;
        if(StringUtils.isNotBlank(path) && CollectionUtils.isNotEmpty(interfaceEncryptList)){
            PathMatcher pathMatcher = new AntPathMatcher();
            for (String pattern : interfaceEncryptList) {
                if(pathMatcher.match(pattern, path)){
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
    private boolean isController(String declaringTypeName){
        boolean result = false;
        if(StringUtils.isNotBlank(declaringTypeName)){
            Class<?> clazz = null;
            try {
                clazz = Class.forName(declaringTypeName);
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if(clazz != null){
                Annotation[] annotations = clazz.getAnnotations();
                if(annotations != null && annotations.length > 0){
                    for (Annotation annotation : annotations) {
                        String name = annotation.annotationType().getName();
                        if(StringUtils.isNotBlank(name) && name.contains("Controller")){
                            result = true;
                            break;
                        }
                    }
                }
            }
        }
        return result;
    }

}
