package cn.gtmap.bdcdj.core.encrypt.utils;


import cn.gtmap.bdcdj.core.encrypt.enums.SaltsEnum;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;

/**
 * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
 * @version 1.0 2020-4-16
 * @description aes  加密解密工具类
 */
public class AESutil {

    private static final String CIPHER_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";
    private static final String KEY_ALGORITHM = "AES";
    private static final String base64Key = "1B0EEF110D358E31409FA45A38A1E20D";
    private static byte[] iv = {0x01, 0x23, 0x45, 0x67, 0x89 - 0xFF, 0xAB - 0xFF, 0xCD - 0xFF, 0xEF - 0xFF,
            0x01, 0x23, 0x45, 0x67, 0x89 - 0xFF, 0xAB - 0xFF, 0xCD - 0xFF, 0xEF - 0xFF};


    /**
     * AES 密钥生成方法
     *
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     */
    public static String initKey() {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        kg.init(128);
        SecretKey secretKey = kg.generateKey();
        return parseByte2HexStr(secretKey.getEncoded());
    }


    /**
     * AES 加密方法
     *
     * @param data 待加密字符串
     * @return 加密后的字节数组
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     */
    public static byte[] encrypt(String data) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);

            byte[] key = parseHexStr2Byte(base64Key);
            Key k = new SecretKeySpec(key, KEY_ALGORITHM);
            AlgorithmParameterSpec paramSpec = new IvParameterSpec(iv);
            cipher.init(Cipher.ENCRYPT_MODE, k, paramSpec);

            return cipher.doFinal(data.getBytes());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * AES 解密方法
     *
     * @param data 待解密字节数组
     * @return 解密后的字节数组
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     */
    public static byte[] decrypt(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
            byte[] key = parseHexStr2Byte(base64Key);
            Key k = new SecretKeySpec(key, KEY_ALGORITHM);
            AlgorithmParameterSpec paramSpec = new IvParameterSpec(iv);
            cipher.init(Cipher.DECRYPT_MODE, k, paramSpec);
            return cipher.doFinal(data);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * AES 加密方法 加密成16进制字符串
     * 为增加破解难度 做加盐处理
     *
     * @param data 待加密字符串
     * @return 加密字符串16进制字符串形式输出
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @since ：14:06 2020-5-18
     */
    public static String encodeToHexString(String data) {
        return SaltsEnum.SALTS.getSalt() + Hex.encodeHexString(encrypt(data));
    }


    /**
     * AES 解密方法 将加密后的16进制字符串 解密成明文
     *
     * @param data 待解密的加密字符串
     * @return 解密后的明文字符串
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @since ：14:09 2020-5-18
     */
    public static String decodeFromHexString(String data) throws DecoderException {
        if (StringUtils.startsWithIgnoreCase(data, SaltsEnum.SALTS.getSalt())) {
            if (StringUtils.endsWith(data, Constants.DENG)) {
                //存在一种情况，在sql语句对证件号加 “等”字  截取去除前面拼接的 与后边的等字
                data = StringUtils.removeEnd(StringUtils.removeStartIgnoreCase(data, SaltsEnum.SALTS.getSalt()), Constants.DENG);
                data = new String(decrypt(Hex.decodeHex(data.toCharArray())));
                return data + Constants.DENG;
            } else {
                return new String(decrypt(Hex.decodeHex((StringUtils.removeStartIgnoreCase(data, SaltsEnum.SALTS.getSalt())).toCharArray())));
            }
        }
        return new String(decrypt(Hex.decodeHex(data.toCharArray())));
    }


    /**
     * 将二进制转换成16进制
     *
     * @param buf
     * @return
     */
    public static String parseByte2HexStr(byte buf[]) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; i++) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    /**
     * 将16进制转换为二进制
     *
     * @param hexStr
     * @return
     */
    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte) (high * 16 + low);
        }
        return result;
    }

}
