package cn.gtmap.bdcdj.core.encrypt.utils;


import cn.gtmap.bdcdj.core.encrypt.enums.SaltsEnum;
import cn.gtmap.bdcdj.core.encrypt.enums.SeparatorCharsEnum;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class CryptUtil {
    private static final Set<Class> IGNORE_CLASS = new HashSet();

    private CryptUtil() {
    }

    public static boolean inIgnoreClass(Class cls) {
        return IGNORE_CLASS.contains(cls);
    }

    public static boolean matchHex(String param) {
        if (StringUtils.isBlank(param)) {
            return false;
        } else if (contsiansSalt(param)) {
            return true;
        } else {
            String zjhPattern = "\\d{17}[0-9Xx]|\\d{15}";
            boolean matzjh = Pattern.matches(zjhPattern, param);
            if (matzjh) {
                return false;
            } else {
                String numberPattern = "[0-9]\\d*";
                boolean matchNumber = Pattern.matches(numberPattern, param);
                if (matchNumber) {
                    return false;
                } else if (param.length() % 4 != 0) {
                    return false;
                } else {
                    String pattern = "^[0-9a-f]+$";
                    return Pattern.matches(pattern, param);
                }
            }
        }
    }

    private static boolean contsiansSalt(String param) {
        SaltsEnum[] var1 = SaltsEnum.values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            SaltsEnum saltsEnum = var1[var3];
            if (StringUtils.startsWithIgnoreCase(param, saltsEnum.getSalt())) {
                return true;
            }
        }

        return false;
    }

    public static String getSeparatorChars(String param) {
        if (StringUtils.isBlank(param)) {
            return SeparatorCharsEnum.COMMA.getChars();
        } else if (StringUtils.contains(param, SeparatorCharsEnum.COMMA.getChars())) {
            return SeparatorCharsEnum.COMMA.getChars();
        } else if (StringUtils.contains(param, SeparatorCharsEnum.SLASH.getChars())) {
            return SeparatorCharsEnum.SLASH.getChars();
        } else if (StringUtils.contains(param.trim(), SeparatorCharsEnum.BLANK.getChars())) {
            return SeparatorCharsEnum.BLANK.getChars();
        } else {
            return StringUtils.contains(param, SeparatorCharsEnum.DONUT.getChars()) ? SeparatorCharsEnum.DONUT.getChars() : "";
        }
    }

    static {
        IGNORE_CLASS.add(Byte.class);
        IGNORE_CLASS.add(Short.class);
        IGNORE_CLASS.add(Integer.class);
        IGNORE_CLASS.add(Long.class);
        IGNORE_CLASS.add(Float.class);
        IGNORE_CLASS.add(Double.class);
        IGNORE_CLASS.add(Boolean.class);
        IGNORE_CLASS.add(Character.class);
    }
}
