package cn.gtmap.bdcdj.core.encrypt.utils;

import cn.gtmap.sdk.mybatis.plugin.utils.SM3;
import cn.gtmap.sdk.mybatis.plugin.utils.SaltsEnum;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECCurve.Fp;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GmSm2Util {
    private static BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static BigInteger gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static BigInteger gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static ECDomainParameters ecc_bc_spec;
    private static final int DIGEST_LENGTH = 32;
    private static SecureRandom random = new SecureRandom();
    private static Fp curve;
    private static ECPoint G;
    private static final String PUBLIC_KEY = "PUBLIC_KEY";
    private static final String PRIVATE_KEY = "PRIVATE_KEY";

    public GmSm2Util() {
    }

    public static Map<String, Object> generateKeyPairMap() {
        Map<String, Object> keyMap = new HashMap(4);
        BigInteger privateKey = random(n.subtract(new BigInteger("1")));
        ECPoint publicKey = G.multiply(privateKey).normalize();
        if (checkPublicKey(publicKey)) {
            keyMap.put("PUBLIC_KEY", publicKey);
            keyMap.put("PRIVATE_KEY", privateKey);
            return keyMap;
        } else {
            return null;
        }
    }

    private static String getPublicKey(Map<String, Object> keyMap) {
        ECPoint publicKey = (ECPoint)keyMap.get("PUBLIC_KEY");
        byte[] keyEncoded = publicKey.getEncoded(true);
        return encryptBase64(keyEncoded);
    }

    private static String getPrivateKey(Map<String, Object> keyMap) {
        BigInteger privateKey = (BigInteger)keyMap.get("PRIVATE_KEY");
        byte[] keyEncoded = privateKey.toByteArray();
        return encryptBase64(keyEncoded);
    }

    public static String encrypt(String input) {
        byte[] keyByte = decryptBase64("Ak3tRLNHcQCg4a1NTXldbx1c9RVE5SIUW17ETKgFq3Wa");
        ECPoint point = curve.decodePoint(keyByte);
        byte[] encrypt = new byte[0];

        try {
            encrypt = encrypt(input, point);
        } catch (UnsupportedEncodingException var5) {
            var5.printStackTrace();
        }

        return SaltsEnum.GM_SM2_SALTS.getSalt() + Hex.toHexString(encrypt);
    }

    public static String encrypt(String input, String publickey, String salt) {
        byte[] keyByte = decryptBase64(publickey);
        ECPoint point = curve.decodePoint(keyByte);
        byte[] encrypt = new byte[0];

        try {
            encrypt = encrypt(input, point);
        } catch (UnsupportedEncodingException var7) {
            var7.printStackTrace();
        }

        return salt + Hex.toHexString(encrypt);
    }

    private static byte[] encrypt(String input, ECPoint publicKey) throws UnsupportedEncodingException {
        byte[] inputBuffer = input.getBytes("utf-8");

        byte[] c1Buffer;
        ECPoint kpb;
        byte[] t;
        do {
            BigInteger k = random(n);
            ECPoint c1 = G.multiply(k);
            c1Buffer = c1.getEncoded(false);
            BigInteger h = ecc_bc_spec.getH();
            if (h != null) {
                ECPoint s = publicKey.multiply(h);
                if (s.isInfinity()) {
                    throw new IllegalStateException();
                }
            }

            kpb = publicKey.multiply(k).normalize();
            byte[] kpbBytes = kpb.getEncoded(false);
            t = kdf(kpbBytes, inputBuffer.length);
        } while(allZero(t));

        byte[] c2 = new byte[inputBuffer.length];

        for(int i = 0; i < inputBuffer.length; ++i) {
            c2[i] = (byte)(inputBuffer[i] ^ t[i]);
        }

        byte[] c3 = sm3hash(kpb.getXCoord().toBigInteger().toByteArray(), inputBuffer, kpb.getYCoord().toBigInteger().toByteArray());
        byte[] encryptResult = new byte[c1Buffer.length + c2.length + c3.length];
        System.arraycopy(c1Buffer, 0, encryptResult, 0, c1Buffer.length);
        System.arraycopy(c2, 0, encryptResult, c1Buffer.length, c2.length);
        System.arraycopy(c3, 0, encryptResult, c1Buffer.length + c2.length, c3.length);
        return encryptResult;
    }

    public static String decrypt(String input) {
        try {
            byte[] keyByte = decryptBase64("AKPflclLAvlxbX8yb8okfknP6FKF4Cq2nCYXRodZF7ZV");
            BigInteger privateKey = new BigInteger(keyByte);
            byte[] enStr;
            if (StringUtils.startsWithIgnoreCase(input, SaltsEnum.GM_SM2_SALTS.getSalt())) {
                if (StringUtils.endsWith(input, "等")) {
                    input = StringUtils.removeEnd(StringUtils.removeStartIgnoreCase(input, SaltsEnum.GM_SM2_SALTS.getSalt()), "等");
                    enStr = Hex.decode(input);
                    return URLDecoder.decode(decrypt(enStr, privateKey), "UTF-8") + "等";
                } else {
                    enStr = Hex.decode(StringUtils.removeStartIgnoreCase(input, SaltsEnum.GM_SM2_SALTS.getSalt()));
                    return URLDecoder.decode(decrypt(enStr, privateKey), "UTF-8");
                }
            } else {
                enStr = Hex.decode(input);
                return URLDecoder.decode(decrypt(enStr, privateKey), "UTF-8");
            }
        } catch (UnsupportedEncodingException var4) {
            throw new RuntimeException("解码失败", var4);
        }
    }

    public static String decrypt(String input, String privateKey, String salt) {
        try {
            byte[] keyByte = decryptBase64(privateKey);
            BigInteger newPrivateKey = new BigInteger(keyByte);
            byte[] enStr;
            if (StringUtils.isNotBlank(salt) && StringUtils.startsWithIgnoreCase(input, salt)) {
                if (StringUtils.endsWith(input, "等")) {
                    input = StringUtils.removeEnd(StringUtils.removeStartIgnoreCase(input, SaltsEnum.GM_SM2_SALTS.getSalt()), "等");
                    enStr = Hex.decode(input);
                    return URLDecoder.decode(decrypt(enStr, newPrivateKey), "UTF-8") + "等";
                } else {
                    enStr = Hex.decode(StringUtils.removeStartIgnoreCase(input, SaltsEnum.GM_SM2_SALTS.getSalt()));
                    return URLDecoder.decode(decrypt(enStr, newPrivateKey), "UTF-8");
                }
            } else {
                enStr = Hex.decode(input);
                return URLDecoder.decode(decrypt(enStr, newPrivateKey), "UTF-8");
            }
        } catch (UnsupportedEncodingException var6) {
            throw new RuntimeException("解码失败", var6);
        }
    }

    private static String decrypt(byte[] encryptData, BigInteger privateKey) {
        byte[] c1Byte = new byte[65];
        System.arraycopy(encryptData, 0, c1Byte, 0, c1Byte.length);
        ECPoint c1 = curve.decodePoint(c1Byte).normalize();
        BigInteger h = ecc_bc_spec.getH();
        ECPoint dBC1;
        if (h != null) {
            dBC1 = c1.multiply(h);
            if (dBC1.isInfinity()) {
                throw new IllegalStateException();
            }
        }

        dBC1 = c1.multiply(privateKey).normalize();
        byte[] dBC1Bytes = dBC1.getEncoded(false);
        int klen = encryptData.length - 65 - 32;
        byte[] t = kdf(dBC1Bytes, klen);
        if (allZero(t)) {
            System.err.println("all zero");
            throw new IllegalStateException();
        } else {
            byte[] M = new byte[klen];

            for(int i = 0; i < M.length; ++i) {
                M[i] = (byte)(encryptData[c1Byte.length + i] ^ t[i]);
            }

            byte[] C3 = new byte[32];
            System.arraycopy(encryptData, encryptData.length - 32, C3, 0, 32);
            byte[] u = sm3hash(dBC1.getXCoord().toBigInteger().toByteArray(), M, dBC1.getYCoord().toBigInteger().toByteArray());
            return Arrays.equals(u, C3) ? new String(M, StandardCharsets.UTF_8) : null;
        }
    }

    private static boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    public static boolean checkPublicKey(ECPoint publicKey) {
        if (!publicKey.isInfinity()) {
            BigInteger x = publicKey.getXCoord().toBigInteger();
            BigInteger y = publicKey.getYCoord().toBigInteger();
            if (between(x, new BigInteger("0"), p) && between(y, new BigInteger("0"), p)) {
                BigInteger xResult = x.pow(3).add(a.multiply(x)).add(b).mod(p);
                BigInteger yResult = y.pow(2).mod(p);
                return yResult.equals(xResult) && publicKey.multiply(n).isInfinity();
            }
        }

        return false;
    }

    private static byte[] join(byte[]... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] res = null;

        try {
            byte[][] var3 = params;
            int var4 = params.length;

            for(int var5 = 0; var5 < var4; ++var5) {
                byte[] param = var3[var5];
                baos.write(param);
            }

            res = baos.toByteArray();
        } catch (IOException var7) {
            var7.printStackTrace();
        }

        return res;
    }

    private static byte[] sm3hash(byte[]... params) {
        byte[] res = null;

        try {
            res = SM3.hash(join(params));
        } catch (IOException var3) {
            var3.printStackTrace();
        }

        return res;
    }

    private static byte[] ZA(String IDA, ECPoint aPublicKey) {
        byte[] idaBytes = IDA.getBytes();
        int entlenA = idaBytes.length * 8;
        byte[] entla = new byte[]{(byte)(entlenA & '\uff00'), (byte)(entlenA & 255)};
        return sm3hash(entla, idaBytes, a.toByteArray(), b.toByteArray(), gx.toByteArray(), gy.toByteArray(), aPublicKey.getXCoord().toBigInteger().toByteArray(), aPublicKey.getYCoord().toBigInteger().toByteArray());
    }

    public static String sign(String data, String signFlag, String publicKeyStr, String privateKeyStr) {
        byte[] dePublicKey = decryptBase64(publicKeyStr);
        ECPoint publicKey = curve.decodePoint(dePublicKey);
        byte[] dePrivateKey = decryptBase64(privateKeyStr);
        BigInteger privateKey = new BigInteger(dePrivateKey);
        return sign(data, signFlag, publicKey, privateKey);
    }

    public static String sign(String M, String signFlag, ECPoint publicKey, BigInteger privateKey) {
        byte[] ZA = ZA(signFlag, publicKey);
        byte[] M_ = join(ZA, M.getBytes());
        BigInteger e = new BigInteger(1, sm3hash(M_));

        BigInteger k;
        BigInteger r;
        do {
            do {
                k = random(n);
                ECPoint p1 = G.multiply(k).normalize();
                BigInteger x1 = p1.getXCoord().toBigInteger();
                r = e.add(x1);
                r = r.mod(n);
            } while(r.equals(BigInteger.ZERO));
        } while(r.add(k).equals(n));

        BigInteger s = privateKey.add(BigInteger.ONE).modInverse(n).multiply(k.subtract(r.multiply(privateKey)).mod(n)).mod(n);
        byte[] rBytes = r.toByteArray();
        byte[] sBytes = s.toByteArray();
        String rBase64String = encryptBase64(rBytes);
        String sBase64String = encryptBase64(sBytes);
        return rBase64String + "," + sBase64String;
    }

    public static boolean verify(String data, String signature, String signFlag, String publicKey) {
        byte[] dePublicKey = decryptBase64(publicKey);
        ECPoint aPublicKey = curve.decodePoint(dePublicKey);
        String[] signParts = signature.split(",");
        if (signParts.length < 2) {
            return false;
        } else {
            String rPart = signParts[0];
            String sPart = signParts[1];
            BigInteger r = new BigInteger(decryptBase64(rPart));
            BigInteger s = new BigInteger(decryptBase64(sPart));
            if (!between(r, BigInteger.ONE, n)) {
                return false;
            } else if (!between(s, BigInteger.ONE, n)) {
                return false;
            } else {
                byte[] M_ = join(ZA(signFlag, aPublicKey), data.getBytes());
                BigInteger e = new BigInteger(1, sm3hash(M_));
                BigInteger t = r.add(s).mod(n);
                if (t.equals(BigInteger.ZERO)) {
                    return false;
                } else {
                    ECPoint p1 = G.multiply(s).normalize();
                    ECPoint p2 = aPublicKey.multiply(t).normalize();
                    BigInteger x1 = p1.add(p2).normalize().getXCoord().toBigInteger();
                    BigInteger R = e.add(x1).mod(n);
                    return R.equals(r);
                }
            }
        }
    }

    private static byte[] kdf(byte[] Z, int klen) {
        int ct = 1;
        int end = (int)Math.ceil((double)klen * 1.0D / 32.0D);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        try {
            for(int i = 1; i < end; ++i) {
                baos.write(sm3hash(Z, SM3.toByteArray(ct)));
                ++ct;
            }

            byte[] last = sm3hash(Z, SM3.toByteArray(ct));
            if (klen % 32 == 0) {
                baos.write(last);
            } else {
                baos.write(last, 0, klen % 32);
            }

            return baos.toByteArray();
        } catch (Exception var6) {
            var6.printStackTrace();
            return null;
        }
    }

    public static String encryptBase64(byte[] key) {
        return new String(Base64.encodeBase64(key), StandardCharsets.UTF_8);
    }

    public static byte[] decryptBase64(String key) {
        try {
            return Base64.decodeBase64(key.getBytes(StandardCharsets.UTF_8));
        } catch (IllegalArgumentException var5) {
            byte[] bytes;
            try {
                bytes = Base64.decodeBase64(key.getBytes(StandardCharsets.UTF_8));
            } catch (Exception var4) {
                throw new RuntimeException(key + " Base64.getMimeDecoder()解码失败", var4);
            }

            if (null != bytes && bytes.length != 0) {
                return bytes;
            } else {
                throw new RuntimeException(key + " Base64.getMimeDecoder()解码失败,返回空串");
            }
        }
    }

    private static BigInteger random(BigInteger max) {
        BigInteger r;
        for(r = new BigInteger(256, random); r.compareTo(max) >= 0; r = new BigInteger(128, random)) {
        }

        return r;
    }

    private static boolean allZero(byte[] buffer) {
        if (null != buffer && buffer.length != 0) {
            byte[] var1 = buffer;
            int var2 = buffer.length;

            for(int var3 = 0; var3 < var2; ++var3) {
                byte value = var1[var3];
                if (value != 0) {
                    return false;
                }
            }

            return true;
        } else {
            throw new RuntimeException("目标数组为空");
        }
    }

    public static void main(String[] args) {
        System.out.println("-----------------公钥加密与解密-----------------");
        Map<String, Object> stringObjectMap = generateKeyPairMap();
        System.out.println(getPublicKey(stringObjectMap));
        System.out.println(getPrivateKey(stringObjectMap));
        System.out.println((BigInteger)stringObjectMap.get("PRIVATE_KEY"));
        String mw = "中国银行定淮门支行营业部中国银行定淮门支行营业部";
        System.out.println("加密前明文：" + mw + "----明文长度：" + mw.length());
        String encrypt = encrypt(mw, getPublicKey(stringObjectMap), "");
        System.out.println("密文:" + encrypt + "密文长度：" + encrypt.length());
        System.out.println("解密后明文:" + decrypt(encrypt, getPrivateKey(stringObjectMap), ""));

    }

    static {
        curve = new Fp(p, a, b);
        G = curve.createPoint(gx, gy);
        ecc_bc_spec = new ECDomainParameters(curve, G, n);
    }
}

