package cn.gtmap.estateplat.config.core.aop;/*
 * @author <a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
 * @version 1.0, 2018/2/12
 * @description 
 */

import cn.gtmap.estateplat.config.core.model.BdcZtglLog;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.util.ThreadPool;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

public class ZTGLLOG {
    @Autowired
    private EntityMapper entityMapper;
    private final Logger logger =  LoggerFactory.getLogger(getClass());

    public  void insertLog(final JoinPoint joinPoint,final Throwable e){
        ThreadPool.execute(new Runnable() {
            public void run() {
                BdcZtglLog bdcZtglLog=new BdcZtglLog();
                BdcZs bdcZs= (BdcZs) joinPoint.getArgs()[0];
                if(null !=bdcZs){
                    //增加log
                    bdcZtglLog.setLogid(UUIDGenerator.generate18());
                    bdcZtglLog.setCqzh(bdcZs.getBdcqzh());
                    bdcZtglLog.setBdcdyh(bdcZs.getBdcdyh());
                    bdcZtglLog.setGxlx("BdczsZtGx");
                    bdcZtglLog.setCwxx(e.toString());
                    bdcZtglLog.setGxsj(new Date());
                    entityMapper.saveOrUpdate(bdcZtglLog,bdcZtglLog.getLogid());
                }
            }
         });
    }

    public void afterThrowing(final JoinPoint joinPoint,Throwable e) {
        if (e instanceof Exception) {
            insertLog(joinPoint,e);
            logger.error("通知中发现异常Exception", e);
        } else {
            logger.error("通知中发现未知异常", e);
        }
    }
}
