package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.BdcGdDyhRel;
import cn.gtmap.estateplat.model.server.core.GdFwsyq;
import cn.gtmap.estateplat.model.server.core.GdTdsyq;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2018-06-02.
 * @description 由于东北地区实体与common包不一致 东北区域 业务库查询 独立Mapper
 */
@Repository
public interface BdcDbqyMapper {


    /**
     * 查询BDC_XM实体
     * @param paramMap
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    List<Map<String,Object>> queryBdcXm(Map<String,Object> paramMap);


    /**
     * 查询BDC_BDCDY 实体
     * @param paramMap
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    List<Map<String,Object>> queryBdcdy(Map<String,Object> paramMap);

    /**
     * 查询 BDC_SPXX 实体
     * @param paramMap
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    List<Map<String,Object>> queryBdcSpxx(Map<String,Object> paramMap);


    /**
     * 查询 GD_DYH_REL 实体
     * @param paramMap
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    List<BdcGdDyhRel> queryGdDyhRel(Map<String,Object> paramMap);


    /**
     * 查询GD_TD 实体
     * @param paramMap
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    List<Map<String,Object>> queryGdTd(Map<String,Object> paramMap);


    /**
     * 根据BDCID 查询GD_YG 权利数量
     * @param  bdcid
     * @return
     * @throws 
     * @author 2018-06-02 lyq
     */
    Integer getGdYgQlByBdcid(String bdcid);

    /**
     * 根据BDCID 查询GD_DYAQ 权利数量
     * @param bdcid
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    Integer getGdDyaQlByBdcid(String bdcid);

    /**
     * 根据BDCID 查询GD_YY 权利数量
     * @param bdcid
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    Integer getGdYyQlByBdcid(String bdcid);

    /**
     * 根据BDCID 查询GD_CF 权利数量
     * @param bdcid
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    Integer getGdCfQlByBdcid(String bdcid);

    /**
     * 根据BDCID 查询GD_YCF 权利数量
     * @param bdcid
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    Integer getGdYCfQlByBdcid(String bdcid);

    /**
     * 查询GD_TDSYQ 实体
     * @param paramMap
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    List<GdTdsyq> queryGdTdsyq(Map<String,Object> paramMap);

    /**
     * 查询GD_FWSYQ 实体
     * @param paramMap
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    List<GdFwsyq> queryGdFwsyq(Map<String,Object> paramMap);


    /**
     * 根据GDID查询 GD_FWsyq QLID LIST
     * @param qlid
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    List<String> getGdFwsyqQlidListByGdid(String qlid);
}