package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.BdcFdcqDz;
import cn.gtmap.estateplat.model.server.core.BdcFwfzxx;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by lst on 2015/3/18
 *
 * @description 房地产权登记信息（项目内多幢房屋）
 */
@Repository
public interface BdcFdcqDzMapper {
    /**
     * g根据权利Id获取对多幢项目对应的项目集合
     *
     * @param qlid
     * @return
     */
    List<BdcFwfzxx> queryBdcFwfzxxlstByQlid(final String qlid);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @Description:根据proid获取项目对应的项目集合
     * @Date 14:50 2017/8/9
     */
    List<BdcFwfzxx> queryBdcFwfzxxlstByProid(final String proid);

    /**
     * 获取房地产权登记信息（项目内多幢房屋）
     *
     * @param proid
     * @return
     */
    BdcFdcqDz getBdcFdcqDz(final String proid);

    void saveFdcqDzTdsyqx(BdcFdcqDz bdcFdcqDz);

    /**
     * 获取房地产权登记信息（项目内多幢房屋）
     *
     * @param map
     * @return
     */
    List<BdcFdcqDz> getBdcFdcqDzList(Map map);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 房地产权共有方式
     */
    List<HashMap> getFdcqGyfsByProid(String proid);
    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:bdcdyid
    *@Description:获取多幢房地产权
    *@Date 10:41 2017/12/21
    */
    List<BdcFdcqDz> getBdcFdcqDzByBdcdyid(String bdcdyid);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param bdcFdcqDz
     * @return
     * @description 更新房地产权多幢权利冗余字段
     */
    void updateBdcfdcqDzRedundantField(BdcFdcqDz bdcFdcqDz);
}
