package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcQlrbqh;
import cn.gtmap.sdk.mybatis.plugin.annotation.Crypt;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Component
public interface BdcQlrMapper {

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过hashmap获取bdc_qlr数据
     * @Table bdc_qlr
     **/
    List<BdcQlr> getBdcQlrList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过hashmap只获取bdc_qlr的名称和证件号
     * @Table bdc_qlr
     **/
    @Crypt(decryptKeys = "qlrzjh")
    List<Map> getBdcQlrMcAndZjhByMap(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 根据权利人和权利人类型获取权利人名称
     * @Table bdc_qlr
     **/
    List<String> getQlrMcByProid(@Param("proid") String proid, @Param("qlrlx") String qlrlx);

    /**
     * 根据证书获取不动产权利人
     *
     * @param map
     * @return
     */
    List<BdcQlr> findQlrByZsInfo(Map map);

    /**
     * 根据项目id获取共有方式
     *
     * @param proid
     * @return
     */
    List<String> getGyfsByProid(final String proid);

    /**
     * 获取不动产权利人
     *
     * @param map
     * @return
     */
    List<BdcQlr> queryBdcQlrList(Map map);

    /**
     * @author <a href="mailto:zhuwei@gtmap.cn">zhuwei</a>
     * @description 根据条件获取BdcQlrbqh
     */
    List<BdcQlrbqh> getBdcQlrbqhListByMap(Map map);

    @Crypt(encryptKeys = "qlrzjh",decryptKeys = "qlrzjh")
    List<Map> getQlrListByPage(Map map);
}
