package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.BdcTd;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zzhw
 * @version V1.0, 15-3-18
 * @description 宗地信息
 */
@Repository
public interface BdcTdMapper {
    /**
     * zzhw 根据宗地宗海号查找BdcTd
     *
     * @param zdzhh
     * @return
     */
    BdcTd selectBdcTd(String zdzhh);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 根据宗地特征码获取判定方式
     */
    HashMap<String, String> getFsAndDefaultZdLbByZdTzm(@Param(value = "zdtzm") String zdtzm);

    /**
     * @param
     * @return List<Map>
     * @author wangtao
     * @description
     */
    List<Map> getZdyt();

    /**
     * @param proid
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @rerutn
     * @description 宗地信息表单数据获取
     */
    List<Map> getBdcZdxxList(String proid);
    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:bdcdyid
    *@Description:
    *@Date 16:24 2017/12/21
    */
    List<String> getProidListByBdcdyid(String bdcdyid);
}
