package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Component
public interface BdcXmMapper {

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过hashmap获取bdc_xm数据
     * @Table bdc_xm
     **/
    List<BdcXm> getBdcXmList(HashMap hashMap);


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 关联bdc_xm和bdc_bdcdy然后通过相关参数查询bdc_xm数据
     * @Table bdc_xm bdc_bdcdy
     **/
    List<BdcXm> getBdcXmByBdcBdcdy(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 查询裁定项目proid
     * @Table bdc_xm bdc_bdcdy bdc_cf
     **/
    List<BdcXm> getCdBdcXmProidByBdcdyh(@Param("bdcdyh") String bdcdyh, @Param("sqlx") String sqlx);

    /**
     * @param bdcdyh
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @rerutn List<BdcCf>
     * @description 根据不动产单元号查询查封项目
     */
    List<BdcXm> getCfXmByBdcdyh(final String bdcdyh);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过bdcqzh获取相应的项目proid
     * @Table bdc_xm bdc_xmzs_rel bdc_zs
     **/
    List<BdcXm> getBdcXmByBdcZsMap(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:jiangganzhi@gtmap.cn">jiangganzhi</a>
     * @rerutn
     * @description 根据wiid获取当前项目对应不动产单元数量
     */
    Integer getBdcdyCountByWiid(String wiid);

    /**
     * 获取登记事由
     *
     * @return
     */
    String getDjsy(String proid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 通过bdcdyid查询所有产生证书证明的项目
     **/
    List<String>listZsZmProidByBdcdyid(String bdcdyid);


    /**
     * 根据流程定义id获取所有类型
     *
     * @param wdid
     * @return
     */
    List<Map> getAllLxByWdid(String wdid);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param bdcXm
     * @return
     * @description 更新项目表冗余字段
     */
    void updateBdcXmRedundantField(BdcXm bdcXm);
}
