package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.BdcXmzsRel;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Component
public interface BdcXmRelMapper {

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过hashmap获取相应的bdc_xm_rel关联表
     * @Table bdc_xm_rel
     **/
    List<BdcXmRel> getBdcXmRelByMap(HashMap hashMap);

    /**
     * @param proid 不动产登记项目ID
     * @return 上一手不动产登记项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 根据不动产登记项目ID获取上一手不动产登记项目ID
     * @Tabel bdc_xm_rel
     */
    String getYproid(String proid);

    /**
     * sc 根据原项目ID和不动产单元号获取项目关系表
     *
     * @param hashMap
     * @return
     * @Table bdc_xm_rel bdc_xm bdc_bdcdy
     */
    public List<BdcXmRel> getBdcXmRelByBdcdyAndBdcXm(HashMap hashMap);

    /**
     * @param wiid
     * @return
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 通过wiid获取相应的bdc_xm_rel数据
     **/
    List<BdcXmRel> listBdcXmRelByWiid(@Param("wiid") String wiid);


}


