package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.*;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/27.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Component
public interface BdcZdGlMapper {
    /**
     * @param hashMap
     * @author <a href="mailto:liubin@gtmap.cn">liubin</a>
     * @rerutn
     * @description 获取查封类型字典
     */
    List<HashMap> getBdcZdCflx(HashMap hashMap);

    /**
     * 获取申请类型字典数据列表
     *
     * @Table bdc_zd_sqlx
     */
    List<BdcZdSqlx> getBdcZdSqlxList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取权利类型字典表
     * @Table bdc_zd_qllx
     **/
    List<BdcZdQllx> getBdcZdQllxList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取验证字典表
     * @Table bdc_zd_check
     **/
    List<BdcZdCheck> getBdcZdCheckList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取配置字典表
     * @Table bdc_zd_tables
     **/
    List<BdcZdTables> getBdcZdTableList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取房屋类型字典表
     * @Table bdc_zd_fwlx
     **/
    List<BdcZdFwlx> getBdcZdFwlxList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取登记类型字典表
     * @Table bdc_zd_djlx
     **/
    List<BdcZdDjlx> getBdcZdDjlxList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 根据获取相对应的特征码字典表
     * @Table BDC_ZD_DZWTZM
     **/
    List<Map> getBdcZdDzwtzmList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取相对应的权利性质
     * @Table BDC_ZD_QLXZ
     **/
    List<Map> getBdcZdQlxzList(Map<String, String> map);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取相对应的抵押方式
     * @Table BDC_ZD_DYFS
     **/
    List<Map> getBdcZdDyfsList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取相对应的宗地特征码
     * @Table BDC_ZD_ZDTZM
     **/
    List<Map> getBdcZdZdtzmList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取相对应的不动产类型字典表
     * @Table BDC_ZD_BDCLX
     **/
    List<Map> getBdcZdBdclxList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 根据登记类型获取相对应的申请类型
     * @Table BDC_DJLX_SQLX_REL bdc_zd_sqlx
     **/
    List<BdcZdSqlx> getBdcZdSqlxByDjlx(String djlxdm);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 根据申请类型获取相对应的登记类型
     **/
    List<BdcZdDjlx> getBdcZdDjlxBySqlx(String sqlxdm);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取对应的证件类型
     * @Table BDC_ZD_ZJLX
     **/
    List<BdcZdZjlx> getBdcZdZjlxList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取相对应面积单位字典表
     **/
    List<HashMap> getBdcZdMjdwList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取相应的登记事由字典表
     **/
    List<HashMap> getBdcZdDjsyList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取相应的登记子项字典表
     **/
    List<BdcZdDjzx> getBdcZdDjzxList(HashMap hashMap);

    List<HashMap> getBdcZdBdcdyFwlxByMap(HashMap hashMap);

    List<BdcZdQllx> getBdcZdQllxListByBdcSqlxQllxRel(HashMap hashMap);

    List<HashMap> getQlrxzList();

    List<HashMap> getQlrlxList();

    //获取性质字典表
    List<HashMap> getQlxzZdb(HashMap hashMap);

    /**
     * @param hashMap
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @rerutn BdcZdQllx
     * @description 获取权利类型字典
     */
    List<BdcZdQllx> getbdcZdQllx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @rerutn
     * @description 获取不动产字典权利取得方式
     */
    List<Map> getBdcZdQlsdfs(HashMap map);

    /**
     * 获取共有方式字典表
     *
     * @return
     */
    List<Map> getZdGyfs();

    /**
     * @param
     * @return
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 获取bdclx与qllx字典表
     */
    List<Map<String, String>> listBdcBdclxQllxRel(Map<String, Object> paramMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取登记类型字典
     */
    List<HashMap> getBdcZdDjlx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取抵押不动产类型类型字典
     */
    List<HashMap> getBdcZdDybdclx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据代码获取共有方式
     */
    List<HashMap> getBdcZdGyfsByDm(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据代码获取共有方式
     */
    String getGyfsByDm(String dm);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description
     */
    List<HashMap> getBdcZdGzwlx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取权籍宗地宗海用途
     */
    List<HashMap> getBdcZdzhyt(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取权籍无居民海岛用途
     */
    List<HashMap> getBdcWjmhdyt(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取用海类型
     */
    List<HashMap> getBdcZdYhlx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取用海类型B
     */
    List<HashMap> getBdcZdYhlxb(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取海域等别
     */
    List<HashMap> getBdcZdHydb(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description
     */
    List<Map> getbdcZdQllxMap(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据不动产类型获取djlx
     */
    List<Map> getDjlxByBdclx(@Param("bdclxdm") String bdclxdm);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据djlx获取sqlx
     */
    List<Map> getSqlxByDjlx(@Param("djlxdm") String djlxdm);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 转换名称为代码
     */
    String parseNameToCode(Map<String, String> paramMap);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 转换代码为名称
     */
    String parseCodeToName(Map<String, String> paramMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 用海类型
     */
    List<HashMap> getBdcZdYhfs(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 水域滩涂类型
     */
    List<HashMap> getBdcZdSyttlx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 养殖方式
     */
    List<HashMap> getBdcZdYzfs(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 承包方式
     */
    List<HashMap> getBdcZdCbjyqqdfs(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 项目性质
     */
    List<HashMap> getBdcZdXmxz(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 房屋性质
     */
    List<HashMap> getDjsjZdFwxz(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 房屋性质
     */
    List<HashMap> getDjsjZdFwjg(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 林种
     */
    List<HashMap> getBdcZdLz(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 林地起源
     */
    List<HashMap> getDjsjZdLdqy(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 权籍s_zd_dldm
     */
    List<HashMap> getDjsjZdDldm(HashMap hashMap);

    /**
     * @author:<a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @data:2016/3/30
     * @param:HashMap
     * @return:List<BdcZdSqlx>
     * @description: 字典写了要可拓展的, 不要定死一个字段
     */
    List<BdcZdSqlx> getBdcSqlxByMap(HashMap hashMap);
    /**
     * zdd 获取登记类型申请类型关系表
     *
     * @return
     */
    List<Map> getDjlxSqlxRel();
    /**
     * @param dm 登记事由名称
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @rerutn
     * @description 根据代码 查  登记事由名称
     */
    String getDjsyByDm(String dm);
}
