package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.BdcZsbh;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/26.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Component
public interface BdcZsBhMapper {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过证书编号查询BdcZsBh数据
     * @Table bdc_zsbh
     **/
    List<BdcZsbh> getBdcZsBhListByBhfw(Map map);

    //根据起止箱号获取编号
    List<BdcZsbh> getBdcZsBhListByQzBh(Map map);

    //根据箱号获取编号数量
    int getCountBdcZsBhByXh(String xh);

    /**
     * 用印号分配到乡镇
     *
     * @param hashMap
     * @return
     */
    String getZsbhByDwdm(HashMap hashMap);

    String getZsbh(String zslx);

    /**
     * 获取证书编号预警内容
     *
     * @param zslx
     * @return
     */
    Map getZsYjByZslx(String zslx);

    /**
     * 更新证书编号
     *
     * @param zsbh
     */
    void updateZsSyData(BdcZsbh zsbh);

    /**
     * 获取证书编号前六位
     *
     * @return
     */
    String getDefaultSixNumZsBh(String zslx);
}
