package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXmzsRel;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Component
public interface BdcZsMapper {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 搜索proid对应的所有的证书
     * @Table bdc_zs bdc_xmzs_rel
     **/
    List<BdcZs> getBdcZsByProid(final String proid);

    /**
     * lst 根据wiid获取批量证书
     *
     * @param wiid
     * @return
     */
    List<BdcZs> getPlZsByWiid(String wiid);

    /**
     * 获取核定日期
     *
     * @param map
     * @return
     */
    Map<String, Object> getHdrqByWiid(HashMap map);

    /**
     * @param map
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 获取视图不动产证书信息
     */
    List<HashMap> getViewBdcqzList(HashMap map);

    /**
     * @author
     * @description 通过zsid获取bdcdy数量
     */
    Integer getBdcdyCountByZsid(@Param("zsid") String zsid);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">juyulin</a>
     * @description 取出时全部不动产权证书证明信息
     */
    List<BdcZs> listBdcZsxx(Map map);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param map
     * @return
     * @description 获取不动产权证书证明信息
     */
    List<BdcZs> getBdcZsList(Map map);

    /**
     * @param bdcqzh
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 根据不动产权证号获取不动产单元号
     */
    List<String> getBdcdyhByBdcqzh(@Param("bdcqzh") String bdcqzh);

    /**
     * @param bdcqzh
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 根据不动产权证号获取项目id
     */
    List<String> getProidByBdcqzh(String bdcqzh);
    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@Description:获取证书个数
    *@Date 9:42 2017/12/25
    */
    Integer getBdczsCount();

    /**
     *@Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     *@Description:根据条件获取所有证书证明号
     *@Date 9:42 2017/12/26
     */
    List<String> listPlZsZmh(Map map);

    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:bdcqzh
    *@Description:获取bdcxm
    *@Date 18:19 2018/1/3
    */
    List<BdcXm> getBdcXmByBdcqzh(Map map);

    /**
     * @Author:<a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param: qlrid
     * @Description: 根据qlrid获取证书
     * @Date 10:12 2018/3/18
     */
    List<BdcZs> getBdcZsByQlrid(final String qlrid);
    /**
     * 获取不动产权证流水号序列
     * @return
     */
    public Integer getMaxLshByXl(HashMap map);
    /**
     * zdd 获取最大流水号
     * sc 根据年份过滤
     *
     * @return
     */
    Integer getMaxLsh(Map map);

    /**
     *根据不动产权证号获取bdc_xmzs_rel数据
     * @param bdcqzh
     * @return
     */
     List<BdcXmzsRel> getBdcXmzsRelByBdcqzh(String bdcqzh);

     /**
      * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
      * @param bdcZs
      * @return
      * @description 更新证书表冗余字段
      */
    void updateBdcZsRedundantField(BdcZs bdcZs);

}
