package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.BdcBdcdy;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Component
public interface BdcdyMapper {
    /**
     * @param
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @rerutn
     * @description 根据不动产单元号查询CQQID
     * @Table djsj_fw_xmxx djsj_fw_ljz djsj_fwhs
     */
    List<String> getCqqidByBdcdy(final String bdcdyh);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据proid查询不动产单元
     */
    BdcBdcdy getBdcdyByProid(final String proid);

    /**
     * 匹配不动产单元和房产证
     *
     * @param map
     * @return
     */
    List<String> queryBdcdyhByDah(final Map map);

    /**
     * @param
     * @return
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 找出该流程所有不动产单元
     **/
    List<BdcBdcdy> listBdcBdcdy(final String wiid);

    /**
     * 获取权利人
     *
     * @param map
     * @return
     */
    List<Map> getDjQlrList(Map map);


    /**
     * @param map 查询条件
     * @return 最大不动产单元号流水号
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 获取最大的不动产单元号流水号
     */
    Integer getMaxBdcdyhLsh(Map map);

}
