package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.*;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Component
public interface DjsjMapper {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取相应的土地地籍数据
     * @Table djsj_bdcdy_td
     **/
    List<DjsjBdcdy> getDjsjBdcdyTdList(HashMap hashMap);

    /**
     * @param map
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 根据宗地变更后的地籍号查询变更前的原地籍号
     * @Table
     */
    List<String> getYdjhByDjh(HashMap map);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 根据参数获取房屋地籍数据
     **/
    List<DjsjBdcdy> getDjsjBdcdyTdFwList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过相关参数搜索djsj_zd_dcb数据
     * @Table djsj_zd_dcb
     **/
    List<DjsjZdxx> getDjsjZdxxList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过id读取林权信息
     * @Table DJSJ_LQ_DCB
     **/
    DjsjLqxx getDjsjLqxx(@Param("id") final String id);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过djid搜索承包宗地地籍数据
     * @Table djsj_cbzd_dcb
     **/
    DjsjCbzdDcb getDjsjCbzdDcbByDjid(final String djid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过djid获取承包方数据
     **/
    DjsjCbzdCbf getDjsjCbzdCbf(final String djid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过djh获取农用地地籍数据
     * @Table djsj_nyd_dcb
     **/
    List<DjsjNydDcb> getDjsjNydDcbByDjh(final String djh);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过djh获取权属宗地地籍数据
     * @Table djsj_qszd_dcb
     **/
    List<DjsjQszdDcb> getDjsjQszdDcb(final String djh);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过id获取农用地信息
     * @Table djsj_nyd_dcb
     **/
    List<DjsjZdxx> getDjsjNydxx(@Param("id") final String id);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 获取房屋项目信息
     */
    List<DjsjFwXmxx> getDjsjFwXmxx(Map<String, Object> paramMap);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 获取房屋逻辑幢信息
     */
    List<DjsjFwLjz> getDjsjFwLjz(Map<String, Object> paramMap);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 获取房屋户室信息
     */
    List<DjsjFwHs> getDjsjFwHs(Map<String, Object> paramMap);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 获取房屋户室总面积
     */
    List<DjsjFwHs> getDjsjFwHsSumMj(Map<String, Object> paramMap);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 获取房屋预测户室信息
     */
    List<DjsjFwHs> getDjsjFwYcHs(Map<String, Object> paramMap);

    /**
     * 通过id读取房屋信息
     *
     * @param bdcdyh
     * @return
     */
    List<DjsjFwxx> getDjsjFwQlr(@Param("id") final String bdcdyh);

    /**
     * 通过djh读取宗地信息
     *
     * @param djh
     * @return
     */
    List<DjsjZdxx> getDjsjZdxxForDjh(final String djh);

    /**
     * 通过djh读取宗海信息
     *
     * @param djh
     * @return
     */
    List<DjsjZhxx> getDjsjZhxxForDjh(final String djh);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 获取宗地信息
     */
    List<DjsjZdxx> getDjsjZdxx(final String id);

    /**
     * 通过djh读取农用地信息
     *
     * @param djh
     * @return
     */
    List<DjsjZdxx> getDjsjNydxxByDjh(@Param("djh") final String djh);

    /**
     * 通过id读取宗海信息
     *
     * @param id
     * @return
     */
    DjsjZhxx getDjsjZhxx(@Param("id") final String id);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 获取地籍数据不动产单元
     */
    List<Map<String, String>> getDjBdcdyListByPage(Map<String, Object> paramMap);

    /**
     * 通过djh读取林权信息
     *
     * @param djh
     * @return
     */
    List<DjsjLqxx> getDjsjLqxxByDjh(@Param("djh") String djh);

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 根据bdcdyh获取承包宗地信息
     */
    List<DjsjCbzdDcb> getDjsjCbzdDcbByDjh(@Param("djh") String djh);
    /**
     * 获取权利人
     *
     * @param map
     * @return
     */
    List<Map> getDjQlrList(Map map);
   /* *//**
     * 获取不动产单元分页
     *
     * @param map
     * @return
     *//*
    List<Map> getDjsjBdcdyByPage(Map map);*/

    /**
     * @param djh
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @rerutn Integer
     * @description 根据地籍号查询不动产数量
     */
    Integer queryBdcdyCountByDjh(final String djh);
    /**
     * @param bdcdyh
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @rerutn List<String>
     * @description 根据不动产单元号获取房屋类型
     */
    List<String> getBdcfwlxByBdcdyh(String bdcdyh);

}
