package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.GdCf;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public interface GdCfMapper {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过hashmap获取相应的gd_cf数据
     * @Table gd_cf
     **/
    List<GdCf> getGdCfList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description gd_cf和gd_bdc_ql_rel关联，通过相应参数获取gd_cf数据
     * @Table gd_cf gd_bdc_ql_rel
     **/
    List<GdCf> getGdCfListByGdBdcQlRel(HashMap hashMap);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param gdCf
     * @return
     * @description 同步GdCf冗余字段信息
     */
    void updateGdCfRedundantField(GdCf gdCf);
}
