package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.BdcGdDyhRel;
import cn.gtmap.estateplat.model.server.core.GdFw;
import cn.gtmap.estateplat.model.server.core.GdFwQl;
import cn.gtmap.estateplat.model.server.core.GdFwsyq;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Component
public interface GdFwMapper {

    /**
     * @param
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @rerutn
     * @description 根据GdProid获取CQQID
     * @Table gd_fw gd_bdc_ql_rel gd_fwsyq gd_dy gd_cf gd_yg gd_yy
     */
    List<String> getCqqidByGdProid(HashMap map);

    /**
     * 获取房屋信息
     *
     * @param map
     * @return
     * @Table gd_fw gd_bdc_ql_rel
     */
    List<GdFw> getGdFwList(Map map);

    /**
     * 获取过渡权利列表
     *
     * @param map
     * @return
     * @Table gd_fwsyq gd_dy gd_cf gd_yg gd_yy
     */
    List<Map> getGdQlList(Map map);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param qlid 权利ID
     * @return 权利相关的房屋信息
     * @description 根据权利ID查找返回的房屋信息
     */
    List<GdFw> getGdFwByQlid(String qlid);

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param bdcdyh 不动产单元号
     * @return 权利相关的房屋信息
     * @description 根据权利ID查找返回的房屋信息
     */
    List<GdFw> getGdFwBybdcdyh(String bdcdyh);

    /**
     * 获取根据房产证号获取fwid
     *
     * @param fczh
     * @return
     */
    List<String> listFwidByFczh(final String fczh);

    List<String> getCqqidByGdid(String gdid);

    GdFw getGdFwByFwid(String fwid);

    /**
     * 根据房产档案号获取过渡房屋
     *
     * @param fcdah
     * @return
     */
    List<GdFw> getGdFwByDah(String fcdah);


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param gdFwsyq
     * @return
     * @description 更新过渡房屋所有权冗余字段
     */
    void updateGdFwsyqRedundantField(GdFwsyq gdFwsyq);


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param gdFwQl
     * @return
     * @description 更新过渡房屋权利冗余字段
     */
    void updateGdFwQlRedundantField(GdFwQl gdFwQl);
}
