package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.*;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Repository
public interface GdTdMapper {
    /**
     * @param djh
     * @author <a href="mailto:sunchao@gtmap.cn">sc</a>
     * @rerutn
     * @description 根据土地地籍号获取过渡土地权利id
     * @Table gd_bdc_ql_rel  gd_td
     */
    List<String> getGdTdQlidByDjh(String djh);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过gd_td的数据获取相应的gd_tdsyq的数据
     * @Table gd_tdsyq gd_bdc_ql_rel gd_td
     **/
    List<GdTdsyq> getGdTdSyqsByGdTd(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过权利和项目相关参数获取土地信息
     * @Table gd_td gd_bdc_ql_rel gd_td_ql gd_xm
     **/
    List<GdTd> getGdTdListByGdTdQlAndGdXm(HashMap hashMap);

    /**
     * 获取根据土地证号获取tdid
     *
     * @param tdzh
     * @return
     */
    List<String> listTdidByTdzh(final String tdzh);



    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param gdTdsyq
     * @return
     * @description 更新过渡土地所有权冗余字段
     */
    void updateGdTdsyqRedundantField(GdTdsyq gdTdsyq);


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param gdTdQl
     * @return
     * @description 更新过渡土地权利冗余字段
     */
    void updateGdTdQlRedundantField(GdTdQl gdTdQl);
}
