package cn.gtmap.estateplat.config.core.mapper.config;

import cn.gtmap.estateplat.model.server.core.GdXm;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Repository
public interface GdXmMapper {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过gdproid查找相关qlid
     * @Table gd_fwsyq gd_dy gd_cf gd_yg gd_yy gd_tdsyq
     **/
    List<String> getQlidByGdproid(String gdproid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 获取过渡证书证明信息
     * @Table gd_fwsyq gd_dy  gd_yg gd_tdsyq
     **/
    List<Map> listGdZsxx(Map map);


    /**
    * @author <a href="mailto:xusong@gtmap.cn">xusong</a>
    * @param
    * @return
    * @Description: 通过gd_fw_ql和gd_td_ql获取过渡证书证明信息
    */
    List<Map> getGdZsxxList(Map map);
    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@Description:取过渡证书证明个数
    *@Date 16:46 2017/12/25
    */
    Integer listGdZsxxsCount();

    /**
     *@Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     *@Description:根据qlid获取所有过渡证号
     *@Date 9:42 2017/12/26
     */
    List<String> listPlCqzhByQlid(@Param("qlid") String qlid);

    /**
     *@Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     *@Description:根据fwid获取所有该房屋上的权利证号
     *@Date 9:42 2017/12/26
     */
    List<String> listCqzhByFwid(final @Param("fwid") String fwid);

    /**
     *@Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     *@Description:根据tdid获取所有该土地上的证号
     *@Date 9:42 2017/12/26
     */
    List<String> listCqzhByTdid(final @Param("tdid") String tdid);

    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:cqzh
    *@Description:qlid
    *@Date 19:09 2018/1/3
    */
    List<String> getGdproidByCqzh(String cqzh);

    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:gdproid
    *@Description:gdqszt
    *@Date 14:26 2018/1/4
    */
    String getGdQsztByGdproid(String gdproid);

    String getCqzhByGdproid(String proid);

    Map getGxObjectByGdproid(String proid);
	
	//根据gdproid获取gdXm
    List<GdXm> getGdXmListByGdProid(String gdproid);
}
