package cn.gtmap.estateplat.config.core.mapper.sjgl;

/*
 * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
 * @version 1.0, 2017/12/19
 * @description  房屋户室服务
 */

import cn.gtmap.estateplat.model.commodityHouse.projectManage.FcjyXjspfLjz;
import cn.gtmap.estateplat.model.commodityHouse.projectManage.FcjyXjspfh;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public interface FwHsMapper {

    /**
     * @param ljzId 逻辑幢id
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 最大物理层数
     */
    Integer maxWlcs(@Param("ljzId") String ljzId);

    /**
     * @param param
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 获取层数和户室数
     */
    List<Map> listCsAndHss(Map param);

    /**
     * @param fcjyXjspfLjz 新建商品逻辑幢表
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 修改权籍逻辑幢数据
     */
    void updateLjz(FcjyXjspfLjz fcjyXjspfLjz);

    /**
     * @param fcjyXjspfh 新建商品房户表
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 修改权籍户室数据
     */
    void updateFwHs(FcjyXjspfh fcjyXjspfh);

    /**
     * @param fcjyXjspfh 新建商品房户表
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 修改权籍预测户室数据
     */
    void updateFwYchs(FcjyXjspfh fcjyXjspfh);

    /**
     * @param args
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @description 批量化修改户数据
     */
    void updateFwHsByHidList(Map<String, Object> args);

    /**
     * @param args
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @description 批量化修改预测户数据
     */
    void updateFwYchsByHidList(Map<String, Object> args);

    /**
     *@author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     *@param
     *@description 清空逻辑幢房地产开发企业编号
     */
    void clearFcjyXjspfLjzQybhByLjzid(String ljzid);

    /**
     * @param args
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @description 单独修改户室申报价格数据
     */
    void updateFwHsSbjgByHidList(Map<String, Object> args);

    /**
     * @param args
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @description 单独修改户室申报价格数据
     */
    void updateFwYchsSbjgByHidList(Map<String, Object> args);

    /**
     * @param args
     * @author <a href="mailto:wanghaifei@gtmap.cn">wanghaifei</a>
     * @description 单独修改户室预现售状态
     */
    void updateFwhsYxsByHidList(Map<String, Object> args);

    /**
     *@author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     *@param
     *@description 插入实测户室
     */
    void insertFwHsByMap(Map args);

    /**
     *@author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     *@param
     *@description 插入预测户室
     */
    void insertFwYchsByMap(Map args);
}
