package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcCf;

import java.util.List;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface BdcCfService {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过proid查询现势查封
     **/
    BdcCf getXsBdcCfByProid(String proid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过proid查询相应的查封
     **/
    BdcCf getBdcCfByProid(String proid);


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过bdcdyid查询现势查封
     **/
    List<BdcCf> getXsBdcCfListByBdcdyid(String bdcdyid);

    /**
     * 根据主键删除查封.
     *
     * @param ids 主键，多个主键以逗号隔开
     */
    void deleteBdcCfByPrimaryKey(final String ids);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param proid
     * @return List<BdcCf>
     * @description 根据proid获取List<BdcCf>
     */
    List<BdcCf> getBdcCfListByProid(String proid);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param bdcCf
     * @return
     * @description 同步BdcCf冗余字段信息
     */
    void updateBdcCfRedundantField(BdcCf bdcCf);
}
