package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.config.model.InitVoFromParm;
import cn.gtmap.estateplat.model.server.core.*;

import java.util.List;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/4
 * @description 登记薄服务
 */
public interface BdcDjbService {

    /**
     * zdd 根据宗地宗海查找bdcdjb
     *
     * @param zdzhh
     * @return
     */
    BdcBdcdjb selectBdcdjb(final String zdzhh);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 初始化登记簿
     */
    BdcBdcdjb initBdcdjb(final InitVoFromParm initVoFromParm, String djh);

    /*
    * zwq
    * 将权属宗地的信息放入登记簿中
    * */

    void getBdcdjbFromQsdcb(DjsjQszdDcb djsjQszdDcb, BdcBdcdjb bdcdjb);

    /**
     * zdd 将宗地信息读取到不动产登记薄
     *
     * @param djsjNydDcbList
     * @param bdcdjb
     */
    void getBdcdjbFromNydZdxx(List<DjsjNydDcb> djsjNydDcbList, BdcBdcdjb bdcdjb);

    /**
     * zdd 将宗地信息读取到不动产登记薄
     *
     * @param djsjZdxx
     * @param bdcdjb
     */
    void getBdcdjbFromZdxx(DjsjZdxx djsjZdxx, BdcBdcdjb bdcdjb);

    /**
     * zdd 将林权信息读取到不动产登记薄
     *
     * @param djsjLqxx
     * @param bdcdjb
     */
    void getBdcdjbFromLqxx(DjsjLqxx djsjLqxx, BdcBdcdjb bdcdjb);

    /**
     * zhx 将宗海信息读取到不动产登记薄
     *
     * @param djsjZhxx
     * @param bdcdjb
     * @return
     */
    void getBdcdjbFromZhxx(DjsjZhxx djsjZhxx, BdcBdcdjb bdcdjb);


    /**
     * 跟新登记簿登簿人登记时间
     *
     * @param proid
     * @param userName
     */
    void updateDjb(String proid, String userName, QllxVo qllxVo);

}
