package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcGdDyhRel;

import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface BdcGdDyhRelService {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过gdid获取相对应的Gd_Dyh_Rel表数据
     **/
    List<BdcGdDyhRel> getGdDyhRelListByGdid(String gdid);

    /**
     * zx 通过过渡项目id获取查询匹配关系
     * 用其中一个值查询
     *
     * @param
     * @return
     */
    List<BdcGdDyhRel> getGdDyhRelByGdproid(final String gdproid);

    /**
     * @param bdcydh 不动产单元号
     * @return ·
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 根据不动产单元号查询关系
     **/
    List<BdcGdDyhRel> listGdDyhRelByDyh(final String bdcydh);

    /**
     * @param tdid 土地id
     * @return ·
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 根据土地ID查询关系
     **/
    List<BdcGdDyhRel> listGdDyhRelByTdid(final String tdid);
}
