package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcHy;
import cn.gtmap.estateplat.model.server.core.BdcHyFlxx;
import cn.gtmap.estateplat.model.server.core.BdcHyYhydzb;
import cn.gtmap.estateplat.model.server.core.DjsjZhxx;

import java.util.List;

/**
 * @version 1.0, 2017/5/12
 * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
 * @description 不动产登记宗海信息
 */

public interface BdcHyService {
    /**
     * zzhw根据宗地宗海号查找bdc_hy
     *
     * @param zdzhh
     * @return bdchy
     */
    BdcHy selectBdcHy(final String zdzhh);

    /**
     * 根据宗海信息获取bdc_hy
     *
     * @param djsjZhxx
     * @return bdc_hy
     */
    BdcHy getBdcHyFromZhxx(DjsjZhxx djsjZhxx);

    /**
     * 根据bdchy信息获取bdc_hyflxx
     *
     * @param bdcHy
     * @return bdc_hyflxx
     */
    List<BdcHyFlxx> getHyflxxsFromBdcHy(BdcHy bdcHy);

    /**
     * 根据bdchy和宗海权藉数据获取BdcHyYhydzb
     *
     * @param bdcHy
     * @param djsjZhxx
     * @return BdcHyYhydzb
     */
    List<BdcHyYhydzb> getYhydzbFromZhxx(DjsjZhxx djsjZhxx, BdcHy bdcHy);

    /**
     * 根据宗地宗海号删除bdc_hy
     *
     * @param zdzhh
     * @return
     */
    void delBdcHyByZdzhh(final String zdzhh);

    /**
     * 根据hyid删除bdc_hyflxx
     *
     * @param hyid
     * @return
     */
    void delBdcHyFlxxByHyid(final String hyid);

    /**
     * 根据宗地宗海号删除bdc_hy_yhydzb
     *
     * @param zdzhh
     * @return
     */
    void delYhydzbByZdzhh(final String zdzhh);
}
