package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcQlr;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface BdcQlrService {

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过proid获取权利人和证件号
     **/
    List<Map> getQlrMcAndQlrZjhByProid(String proid, String qlrlx);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过proid 或者qlrlx查询bdc_qlr数据
     **/
    List<BdcQlr> getBdcQlrListByProidAndQlrlx(String proid, String qlrlx);

    List<String> getQlrMcByProid(String proid, String qlrlx);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description
     **/
    List<BdcQlr> getBdcQlrListByBdcqzh(String bdcqzh, String qlrlx);

    List<BdcQlr> queryBdcQlrByProid(final String proid);

    List<BdcQlr> queryBdcQlrYwrByProid(final String proid);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据主键删除
     */
    void deleteQlrByPrimaryKey(final String ids);

    /**
     * 根据证书获取qlr
     *
     * @param map
     * @return
     */
    List<BdcQlr> findQlrByZsInfo(Map map);

    /**
     * zdd 组合权利人名称
     *
     * @param bdcQlrList
     * @return
     */
    String combinationQlr(final List<BdcQlr> bdcQlrList);

    /**
     * zdd 只获取义务人
     *
     * @param proid
     * @return
     */
    List<BdcQlr> queryBdcYwrByProid(final String proid);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @Description:组合义务人名称
     * @Date 15:50 2017/2/15
     */
    String combinationYwr(final List<BdcQlr> bdcYwrList);

    /**
     * 根据项目id获取共有方式
     *
     * @param proid
     * @return
     */
    List<String> getGyfsByProid(final String proid);

    String getGyqk(final String proid);

    /**
     * @param bdcQlrList
     * @return
     * @autor <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @description 按份共有中是否包含共有共有
     **/
    Boolean isAfgyContainGtgy(List<BdcQlr> bdcQlrList);

    /**
     * lst 录入土地证信息 权利人
     * sc 多条件查询
     *
     * @param map
     * @return
     */
    List<BdcQlr> queryBdcQlrList(final Map map);

    /**
     * @param bdcQlr
     * @return
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 保存权利人信息
     */
    void saveBdcQlr(BdcQlr bdcQlr);

    /**
     * @param proid
     * @return
     * @autor <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @description 组合权利人和义务人信息
     **/
    Map combinationQlrxxAndYwrxx(String proid);
    /**
     * zdd 根据权利人ID（主键）删除
     *
     * @param qlrid
     */
    void delBdcQlrByQlrid(final String qlrid);
}
