package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcQllxDjsyRel;
import cn.gtmap.estateplat.model.server.core.BdcSqlxDjsyRel;
import cn.gtmap.estateplat.model.server.core.BdcSqlxDjzxRel;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface BdcRelService {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过权利类型获取登记事由
     **/
    String getDjsyMcByQllx(String qllx);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description
     **/
    String getDjsyMcByDjsy(String djsy);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取bdc_qllx_djsy_rel表
     **/
    List<BdcQllxDjsyRel> getBdcQllxDjsyRelByQllxAndDjsy(String qllx, String djsy);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 保存
     **/
    void saveOrUpdateBdcQllxDjsyRel(BdcQllxDjsyRel bdcQllxDjsyRel);


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 删除
     **/
    void delBdcQllxDjsyRel(String qllx);


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 保存
     **/
    void saveOrUpdateBdcSqlxDjsyRel(BdcSqlxDjsyRel bdcSqlxDjsyRel);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过sqldm获取相应的登记子项代码
     **/
    List<BdcSqlxDjzxRel> getDjzxDmBySqlxDm(String sqlx);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 对bdc_sqlx_yh_rel的插入和修改
     **/
    void saveOrUpdateBdcSqlxYhRel(String id, String sqlx);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 删除bdc_sqlx_yh_rel
     **/
    void delBdcSqlxYhRel(String id);

    List<HashMap> getBdcSqlxYhRelBySqlx(String sqlx);

    List<BdcSqlxDjsyRel> getBdcSqlxDjsyRelListBySqlxAndDjsy(String sqlx, String djsy);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 根据id删除
     **/
    void delBdcQllxDjsyRelById(String id);

    List<BdcSqlxDjzxRel> getBdcSqlxDjzxRelBySqlxOrDjzx(String sqlx, String djzx);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 判断是否有值
     **/
    boolean getDataByClass(Object obj, String[] filedNames);
}
