package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.*;

import java.util.List;

/**
 *
 * 不动产收件单和收件材料
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zdd</a>
 * @version V1.0, 15-3-19
 */
public interface BdcSjdService {
    /**
     * 根据不动产相应创建收件信息
     *
     * @param bdcXm
     * @return
     */
    BdcSjxx createSjxxByBdcxm(BdcXm bdcXm);
    /**
     * zdd 根据流程ID 获取收件单信息
     *
     * @param wiid
     */
    List<BdcSjxx> queryBdcSjdByWiid(final String wiid);
    /**
     * 增加收件信息
     *
     * @param bdcSjxx
     */
    void addBdcSjxx(BdcSjxx bdcSjxx);

    /**
     * zdd 根据收件信息删除收件材料
     *
     * @param sjxxid
     */
    void delSjclListBySjxxid(final String sjxxid);
    /**
     * zdd 删除收件单
     *
     * @param sjxxid
     */
    void delBdcSjxxBySjxxid(final String sjxxid);

}
