package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.config.model.InitVoFromParm;
import cn.gtmap.estateplat.model.server.core.BdcTd;

import java.util.List;
import java.util.Map;

/**
 * 不动产登记宗地信息
 *
 * @author zzhw
 * @version V1.0, 15-3-18
 */
public interface BdcTdService {

    /**
     * 根据宗地宗海号删除土地信息
     *
     * @param zdzhh
     */
    void delBdcTdByZdzhh(final String zdzhh);

    /**
     * zzhw根据宗地宗海号查找bdc_td
     *
     * @param zdzhh
     * @return
     */
    BdcTd selectBdcTd(final String zdzhh);

    /**
     * @param
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @rerutn
     * @description 获取宗地类别
     */

    List<Map> getZdty();

    /**
     * @param proid
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @rerutn
     * @description 宗地信息表单数据获取
     */
    List<Map> getBdcZdxxList(String proid);

    /**
     * zx 将地籍库里面的信息继承到bdc_td里面
     *
     * @param initVoFromParm
     * @return
     */
    BdcTd getBdcTdFromDjxx(InitVoFromParm initVoFromParm, String djh);

    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:bdcdyh
    *@Description:
    *@Date 16:23 2017/12/21
    */
    List<String> getProidListByBdcdyid(String bdcdyid);
    /**
     * @param
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @rerutn
     * @description 获取宗地类别
     */
    String getZdLb(final String proid);
    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 根据宗地类别修改面积显示
     */
    String changeMjByZdLb(final String zdLb,final String mj,final String bdclx);
}
