package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.BdcXmzsRel;
import cn.gtmap.estateplat.model.server.core.Project;

import java.util.List;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description 项目关联表
 */
public interface BdcXmRelService {

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过proid获取相应的bdc_xm_rel数据
     **/
    List<BdcXmRel> getBdcXmRelByProid(String proid);

    /**
     * @param proid 不动产登记项目ID
     * @return 上一手不动产登记项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 根据不动产登记项目ID获取上一手不动产登记项目ID
     */
    String getYproid(final String proid);

    /**
     * sc 根据原项目ID和不动产单元号获取项目关系表
     *
     * @param
     * @return
     */
    List<BdcXmRel> getBdcXmRelByYproidAndBdcdyh(String yproid, String bdcdyh);

    /**
     * @param wiid
     * @return
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 通过wiid获取相应的bdc_xm_rel数据
     **/
    List<BdcXmRel> listBdcXmRelByWiid(String wiid);
    /**
     * zdd 根据项目ID删除项目关系表
     *
     * @param proid
     */
    void delBdcXmRelByProid(final String proid);

    /**
     * zdd 根据新建项目信息创建BdcXmrel  未插入数据库
     *
     * @param project
     * @return
     */
    BdcXmRel creatBdcXmRelFromProject(Project project);

}
