package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.TaskInfo;
import cn.gtmap.estateplat.model.server.core.Xmxx;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/28.
 * @author  <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface BdcXmService {
    /**
     * zdd 将子类数据转移到父类
     *
     * @param bdcXm
     * @return
     */
    Project getProjectFromBdcXm(BdcXm bdcXm, Project project);

    /**
     * zhangyu TaskInfo 实体类数据转到Project实体类
     *
     * @param taskInfo
     * @return
     */
    Project getProjectFromTaskInfo(TaskInfo taskInfo,  Project project);

    /**
     * zhangyu  Project 实体类数据转到TaskInfo实体类
     *
     * @param taskInfo
     * @return
     */
    TaskInfo getTaskInfoFromProject(TaskInfo taskInfo,  Project project);


    /**
     * @param
     * @return
     * @author <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过bdcdyh查询bdc_xm
     **/
    List<BdcXm> getBdcXmByBdcdyh(String bdcdyh);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过不动产单元号查询裁定项目proid
     **/
    List<BdcXm> getCdBdcXmByBdcdyh(String bdcdyh);

    /**
     * zdd 根据项目ID获取项目信息
     *
     * @param proid
     * @return
     */
    BdcXm getBdcXmByProid(final String proid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过wiid搜索所有的项目数据
     **/
    List<BdcXm> getBdcXmListByWiid(String wiid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过bdcdyid查询bdc_xm数据
     **/
    List<BdcXm> getBdcXmByBdcdyid(String bdcdyid);

    /**
     * @param bdcdyh
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @rerutn List<BdcCf>
     * @description 根据不动产单元号查询查封项目
     */
    List<BdcXm> getCfXmByBdcdyh(final String bdcdyh);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过bdcqzh获取相应的项目
     **/
    BdcXm getBdcXmByBdcqzh(String bdcqzh);

    /**
     * @param
     * @author <a href="mailto:jiangganzhi@gtmap.cn">jiangganzhi</a>
     * @rerutn
     * @description 根据wiid获取当前项目对应不动产单元数量
     */
    Integer getBdcdyCountByWiid(String wiid);

    /**
     * 获取登记事由
     *
     * @return
     */
    String getDjsy(String proid);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 创建项目
     */
    BdcXm createBdcXm();

    /**
     * @param
     * @author <a href="mailto:jiangganzhi@gtmap.cn">jiangganzhi</a>
     * @rerutn
     * @description 判断是否为合并登记
     */
    Boolean isHb(String proid);

    /**
     * @param bdcXm
     * @return
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @version
     * @description
     */
    void saveBdcXm(BdcXm bdcXm);

    /**
     * @param
     * @return
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 通过bdcdyid查询所有产生证书证明的项目
     **/
    List<String>listZsZmProidByBdcdyid(String bdcdyid);


    /**
     * @param
     * @rerutn
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @description 根据proid获取项目列表
     */
    List<BdcXm> getBdcXmListByProid(final String proid);

    /**
     * 根据流程名称获取所有类型
     *
     * @param wdid
     * @return
     */
    List<Map> getAllLxByWdid(String wdid);


    /**
     * sc:所有流程创建项目
     *
     * @param proid
     * @param userName
     * @param wdid
     * @param wiid     工作流实例ID
     * @return
     */
    BdcXm creatBdcXm(final String proid, final String userName, final String wdid, final String wiid);

    /**
     * zdd 根据项目ID删除项目信息
     *
     * @param proid
     */
    void delBdcXmByProid(final String proid);
    /**
     * zx 获取项目信息
     *
     * @param map
     */
    List<BdcXm> andEqualQueryBdcXm(final HashMap<String, String> map);


    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 获取原项目
     */
    List<BdcXm> getYbdcXmListByProid(final String proid);


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param bdcXm
     * @return
     * @description 更新项目表冗余字段
     */
    void updateBdcXmRedundantField(BdcXm bdcXm);

}
