package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcBdcdy;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXtQlqtzkConfig;

import java.util.List;

/**
 * @version 1.0, 2017/6/27.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface BdcXtQlqtzkConfigService {
    /**
     * 通过sqlx和zlx获取权利其他状况配置
     *
     * @param bdcXtQlqtzkConfig
     */
    List<BdcXtQlqtzkConfig> getQlqtzk(BdcXtQlqtzkConfig bdcXtQlqtzkConfig);

    /**
     * 通过id获取权利其他状况配置
     *
     * @param id
     */
    BdcXtQlqtzkConfig getQlqtzkId(String id);

    /**
     * 新增或修改权利其它状况配置
     *
     * @param bdcXtQlqtzkConfig
     */
    void saveOrUpdateQlqtzk(BdcXtQlqtzkConfig bdcXtQlqtzkConfig) throws Exception;

    /**
     * 删除权利其它状况配置
     *
     * @param bdcXtQlqtzkConfig
     */
    void deleteQlqtzk(BdcXtQlqtzkConfig bdcXtQlqtzkConfig) throws Exception;

    /**
     * 根据数据源替换模板内容
     *
     * @param mb
     * @param sql
     * @param bdcXm
     * @param bdcBdcdy
     * @return
     */
    String replaceMb(String mb, String sql, BdcXm bdcXm, BdcBdcdy bdcBdcdy);
}
