package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcXygl;
import cn.gtmap.estateplat.model.server.core.BdcXymx;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2019/4/24.
 * @auto <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
 * @description 不动产信用管理
 */
public interface BdcXyGlService {

    /**
    * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
    * @param bdcXygl
    * @description  根据主键插入或更新信用管理
    */
    void insertOrUpdateByPrimaryKey(final BdcXygl bdcXygl);

    /**
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @param bdcXymx
     * @description  根据主键插入或更新信用明细
     */
    void insertOrUpdateByPrimaryKey(final BdcXymx bdcXymx);

    /**
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @param ids 多个主键以逗号隔开
     * @description  删除信用管理信息：包括BdcXygl和BdcXymx数据
     */
    void deleteBdcXyGlxx(final String ids);

    /**
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @param hashMap
     * @description  qlrm/qlrzjh获取BdcXyglList
     */
    List<BdcXygl> getBdcXyglListByMap(HashMap hashMap);

    /**
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @param inputStream
     * @description  解析导入的信用管理excel并转为model
     */
    Map<String, String> getExcelAsInputStream(InputStream inputStream);

    /**
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @param bdcXygl
     * @param bdcXymx
     * @description  保存或更新信用管理数据
     */
    void insertOrUpdateBdcXyGlxx(BdcXygl bdcXygl,BdcXymx bdcXymx);

    /**
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @param xyglid
     * @description  根据xyglid获取BdcXymx记录
     */
    List<BdcXymx> getBdcXymxListByXyglid(String xyglid);

}
